// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** A condition to be satisfied for an action to be executed. */
@Fluent
public final class Trigger implements JsonSerializable<Trigger> {
    /*
     * Percentage of lifetime at which to trigger. Value should be between 1 and 99.
     */
    private Integer lifetimePercentage;

    /*
     * Days before expiry to attempt renewal. Value should be between 1 and validity_in_months multiplied by 27. If
     * validity_in_months is 36, then value should be between 1 and 972 (36 * 27).
     */
    private Integer daysBeforeExpiry;

    /** Creates an instance of Trigger class. */
    public Trigger() {}

    /**
     * Get the lifetimePercentage property: Percentage of lifetime at which to trigger. Value should be between 1 and
     * 99.
     *
     * @return the lifetimePercentage value.
     */
    public Integer getLifetimePercentage() {
        return this.lifetimePercentage;
    }

    /**
     * Set the lifetimePercentage property: Percentage of lifetime at which to trigger. Value should be between 1 and
     * 99.
     *
     * @param lifetimePercentage the lifetimePercentage value to set.
     * @return the Trigger object itself.
     */
    public Trigger setLifetimePercentage(Integer lifetimePercentage) {
        this.lifetimePercentage = lifetimePercentage;
        return this;
    }

    /**
     * Get the daysBeforeExpiry property: Days before expiry to attempt renewal. Value should be between 1 and
     * validity_in_months multiplied by 27. If validity_in_months is 36, then value should be between 1 and 972 (36 *
     * 27).
     *
     * @return the daysBeforeExpiry value.
     */
    public Integer getDaysBeforeExpiry() {
        return this.daysBeforeExpiry;
    }

    /**
     * Set the daysBeforeExpiry property: Days before expiry to attempt renewal. Value should be between 1 and
     * validity_in_months multiplied by 27. If validity_in_months is 36, then value should be between 1 and 972 (36 *
     * 27).
     *
     * @param daysBeforeExpiry the daysBeforeExpiry value to set.
     * @return the Trigger object itself.
     */
    public Trigger setDaysBeforeExpiry(Integer daysBeforeExpiry) {
        this.daysBeforeExpiry = daysBeforeExpiry;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("lifetime_percentage", this.lifetimePercentage);
        jsonWriter.writeNumberField("days_before_expiry", this.daysBeforeExpiry);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Trigger from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Trigger if the JsonReader was pointing to an instance of it, or null if it was pointing to
     *     JSON null.
     * @throws IOException If an error occurs while reading the Trigger.
     */
    public static Trigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    Trigger deserializedTrigger = new Trigger();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("lifetime_percentage".equals(fieldName)) {
                            deserializedTrigger.lifetimePercentage = reader.getNullable(JsonReader::getInt);
                        } else if ("days_before_expiry".equals(fieldName)) {
                            deserializedTrigger.daysBeforeExpiry = reader.getNullable(JsonReader::getInt);
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedTrigger;
                });
    }
}
