// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.certificates.implementation.models.BackupCertificateResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.CertificateCreateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateImportParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerListResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerSetParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateListResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateMergeParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateOperation;
import com.azure.security.keyvault.certificates.implementation.models.CertificateOperationUpdateParameter;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.implementation.models.CertificateRestoreParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.Contacts;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateListResult;
import com.azure.security.keyvault.certificates.implementation.models.IssuerAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.implementation.models.IssuerCredentials;
import com.azure.security.keyvault.certificates.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.certificates.implementation.models.OrganizationDetails;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the CertificateClient type. */
public final class CertificateClientImpl {
    /** The proxy service used to perform REST calls. */
    private final CertificateClientService service;

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of CertificateClient client.
     *
     * @param apiVersion Api Version.
     */
    public CertificateClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    /**
     * Initializes an instance of CertificateClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param apiVersion Api Version.
     */
    public CertificateClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    /**
     * Initializes an instance of CertificateClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param apiVersion Api Version.
     */
    public CertificateClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = RestProxy.create(CertificateClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for CertificateClient to be used by the proxy service to perform REST
     * calls.
     */
    @Host("{vaultBaseUrl}")
    @ServiceInterface(name = "CertificateClient")
    public interface CertificateClientService {
        @Get("/certificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateListResult>> getCertificates(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("includePending") Boolean includePending,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateListResult> getCertificatesSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("includePending") Boolean includePending,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedCertificateBundle>> deleteCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedCertificateBundle> deleteCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<Contacts>> setCertificateContacts(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") Contacts contacts,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<Contacts> setCertificateContactsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") Contacts contacts,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<Contacts>> getCertificateContacts(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<Contacts> getCertificateContactsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<Contacts>> deleteCertificateContacts(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<Contacts> deleteCertificateContactsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/issuers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateIssuerListResult>> getCertificateIssuers(
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/issuers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateIssuerListResult> getCertificateIssuersSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<IssuerBundle>> setCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateIssuerSetParameters parameter,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<IssuerBundle> setCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateIssuerSetParameters parameter,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<IssuerBundle>> updateCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateIssuerUpdateParameters parameter,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<IssuerBundle> updateCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateIssuerUpdateParameters parameter,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<IssuerBundle>> getCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<IssuerBundle> getCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<IssuerBundle>> deleteCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<IssuerBundle> deleteCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("issuer-name") String issuerName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/certificates/{certificate-name}/create")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateOperation>> createCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateCreateParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/certificates/{certificate-name}/create")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateOperation> createCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateCreateParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/certificates/{certificate-name}/import")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateBundle>> importCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateImportParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/certificates/{certificate-name}/import")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateBundle> importCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateImportParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/certificates/{certificate-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateListResult>> getCertificateVersions(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/{certificate-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateListResult> getCertificateVersionsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificatePolicy>> getCertificatePolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificatePolicy> getCertificatePolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificatePolicy>> updateCertificatePolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificatePolicy certificatePolicy, @HeaderParam("Accept") String accept,
            Context context);

        @Patch("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificatePolicy> updateCertificatePolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificatePolicy certificatePolicy, @HeaderParam("Accept") String accept,
            Context context);

        @Patch("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateBundle>> updateCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateUpdateParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Patch("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateBundle> updateCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateUpdateParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateBundle>> getCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateBundle> getCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateOperation>> updateCertificateOperation(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateOperationUpdateParameter certificateOperation,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateOperation> updateCertificateOperationSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateOperationUpdateParameter certificateOperation,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateOperation>> getCertificateOperation(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateOperation> getCertificateOperationSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateOperation>> deleteCertificateOperation(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateOperation> deleteCertificateOperationSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateBundle>> mergeCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateMergeParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateBundle> mergeCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateMergeParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/certificates/{certificate-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<BackupCertificateResult>> backupCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/certificates/{certificate-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<BackupCertificateResult> backupCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/certificates/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateBundle>> restoreCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateRestoreParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/certificates/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateBundle> restoreCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CertificateRestoreParameters parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/deletedcertificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedCertificateListResult>> getDeletedCertificates(
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("includePending") Boolean includePending, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/deletedcertificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedCertificateListResult> getDeletedCertificatesSync(
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("includePending") Boolean includePending, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedCertificateBundle>> getDeletedCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedCertificateBundle> getDeletedCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<Void>> purgeDeletedCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<Void> purgeDeletedCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateBundle>> recoverDeletedCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateBundle> recoverDeletedCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @PathParam("certificate-name") String certificateName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateListResult>> getCertificatesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateListResult> getCertificatesNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateIssuerListResult>> getCertificateIssuersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateIssuerListResult> getCertificateIssuersNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<CertificateListResult>> getCertificateVersionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<CertificateListResult> getCertificateVersionsNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedCertificateListResult>> getDeletedCertificatesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedCertificateListResult> getDeletedCertificatesNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults,
        Boolean includePending) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificates(vaultBaseUrl, maxresults, includePending,
                this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults,
        Boolean includePending, Context context) {
        final String accept = "application/json";
        return service.getCertificates(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificatesAsync(String vaultBaseUrl, Integer maxresults,
        Boolean includePending) {
        return new PagedFlux<>(() -> getCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending),
            nextLink -> getCertificatesNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificatesAsync(String vaultBaseUrl, Integer maxresults,
        Boolean includePending, Context context) {
        return new PagedFlux<>(() -> getCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending, context),
            nextLink -> getCertificatesNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesSinglePage(String vaultBaseUrl, Integer maxresults,
        Boolean includePending) {
        final String accept = "application/json";
        Response<CertificateListResult> res = service.getCertificatesSync(vaultBaseUrl, maxresults, includePending,
            this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesSinglePage(String vaultBaseUrl, Integer maxresults,
        Boolean includePending, Context context) {
        final String accept = "application/json";
        Response<CertificateListResult> res = service.getCertificatesSync(vaultBaseUrl, maxresults, includePending,
            this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificates(String vaultBaseUrl, Integer maxresults,
        Boolean includePending) {
        return new PagedIterable<>(
            () -> getCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, Context.NONE),
            nextLink -> getCertificatesNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * List certificates in a specified key vault
     *
     * <p>The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificates(String vaultBaseUrl, Integer maxresults,
        Boolean includePending, Context context) {
        return new PagedIterable<>(() -> getCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, context),
            nextLink -> getCertificatesNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Deletes a certificate from a specified key vault.
     *
     * <p>Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be
     * used to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> deleteCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.deleteCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context));
    }

    /**
     * Deletes a certificate from a specified key vault.
     *
     * <p>Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be
     * used to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> deleteCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.deleteCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes a certificate from a specified key vault.
     *
     * <p>Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be
     * used to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName) {
        return deleteCertificateWithResponseAsync(vaultBaseUrl, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a certificate from a specified key vault.
     *
     * <p>Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be
     * used to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        return deleteCertificateWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a certificate from a specified key vault.
     *
     * <p>Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be
     * used to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeletedCertificateBundle> deleteCertificateWithResponse(String vaultBaseUrl, String certificateName,
        Context context) {
        final String accept = "application/json";
        return service.deleteCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes a certificate from a specified key vault.
     *
     * <p>Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be
     * used to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeletedCertificateBundle deleteCertificate(String vaultBaseUrl, String certificateName) {
        return deleteCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     *
     * <p>Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Contacts>> setCertificateContactsWithResponseAsync(String vaultBaseUrl, Contacts contacts) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.setCertificateContacts(vaultBaseUrl, this.getApiVersion(), contacts, accept, context));
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     *
     * <p>Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Contacts>> setCertificateContactsWithResponseAsync(String vaultBaseUrl, Contacts contacts,
        Context context) {
        final String accept = "application/json";
        return service.setCertificateContacts(vaultBaseUrl, this.getApiVersion(), contacts, accept, context);
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     *
     * <p>Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts) {
        return setCertificateContactsWithResponseAsync(vaultBaseUrl, contacts)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     *
     * <p>Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts, Context context) {
        return setCertificateContactsWithResponseAsync(vaultBaseUrl, contacts, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     *
     * <p>Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Contacts> setCertificateContactsWithResponse(String vaultBaseUrl, Contacts contacts,
        Context context) {
        final String accept = "application/json";
        return service.setCertificateContactsSync(vaultBaseUrl, this.getApiVersion(), contacts, accept, context);
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     *
     * <p>Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Contacts setCertificateContacts(String vaultBaseUrl, Contacts contacts) {
        return setCertificateContactsWithResponse(vaultBaseUrl, contacts, Context.NONE).getValue();
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     *
     * <p>The GetCertificateContacts operation returns the set of certificate contact resources in the specified key
     * vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Contacts>> getCertificateContactsWithResponseAsync(String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getCertificateContacts(vaultBaseUrl, this.getApiVersion(), accept, context));
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     *
     * <p>The GetCertificateContacts operation returns the set of certificate contact resources in the specified key
     * vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Contacts>> getCertificateContactsWithResponseAsync(String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getCertificateContacts(vaultBaseUrl, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     *
     * <p>The GetCertificateContacts operation returns the set of certificate contact resources in the specified key
     * vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Contacts> getCertificateContactsAsync(String vaultBaseUrl) {
        return getCertificateContactsWithResponseAsync(vaultBaseUrl).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     *
     * <p>The GetCertificateContacts operation returns the set of certificate contact resources in the specified key
     * vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Contacts> getCertificateContactsAsync(String vaultBaseUrl, Context context) {
        return getCertificateContactsWithResponseAsync(vaultBaseUrl, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     *
     * <p>The GetCertificateContacts operation returns the set of certificate contact resources in the specified key
     * vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Contacts> getCertificateContactsWithResponse(String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getCertificateContactsSync(vaultBaseUrl, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     *
     * <p>The GetCertificateContacts operation returns the set of certificate contact resources in the specified key
     * vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Contacts getCertificateContacts(String vaultBaseUrl) {
        return getCertificateContactsWithResponse(vaultBaseUrl, Context.NONE).getValue();
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     *
     * <p>Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Contacts>> deleteCertificateContactsWithResponseAsync(String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.deleteCertificateContacts(vaultBaseUrl, this.getApiVersion(), accept, context));
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     *
     * <p>Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Contacts>> deleteCertificateContactsWithResponseAsync(String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.deleteCertificateContacts(vaultBaseUrl, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     *
     * <p>Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl) {
        return deleteCertificateContactsWithResponseAsync(vaultBaseUrl)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     *
     * <p>Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl, Context context) {
        return deleteCertificateContactsWithResponseAsync(vaultBaseUrl, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     *
     * <p>Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Contacts> deleteCertificateContactsWithResponse(String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.deleteCertificateContactsSync(vaultBaseUrl, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     *
     * <p>Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the contacts for the vault certificates.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Contacts deleteCertificateContacts(String vaultBaseUrl) {
        return deleteCertificateContactsWithResponse(vaultBaseUrl, Context.NONE).getValue();
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl,
        Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getCertificateIssuers(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl,
        Integer maxresults, Context context) {
        final String accept = "application/json";
        return service.getCertificateIssuers(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateIssuerItem> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux<>(() -> getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults),
            nextLink -> getCertificateIssuersNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateIssuerItem> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults,
        Context context) {
        return new PagedFlux<>(() -> getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults, context),
            nextLink -> getCertificateIssuersNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersSinglePage(String vaultBaseUrl,
        Integer maxresults) {
        final String accept = "application/json";
        Response<CertificateIssuerListResult> res
            = service.getCertificateIssuersSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersSinglePage(String vaultBaseUrl, Integer maxresults,
        Context context) {
        final String accept = "application/json";
        Response<CertificateIssuerListResult> res
            = service.getCertificateIssuersSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable<>(() -> getCertificateIssuersSinglePage(vaultBaseUrl, maxresults, Context.NONE),
            nextLink -> getCertificateIssuersNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * List certificate issuers for a specified key vault.
     *
     * <p>The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl, Integer maxresults,
        Context context) {
        return new PagedIterable<>(() -> getCertificateIssuersSinglePage(vaultBaseUrl, maxresults, context),
            nextLink -> getCertificateIssuersNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Sets the specified certificate issuer.
     *
     * <p>The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires
     * the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> setCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName,
        String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails,
        IssuerAttributes attributes) {
        final String accept = "application/json";
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return FluxUtil.withContext(context -> service.setCertificateIssuer(vaultBaseUrl, issuerName,
            this.getApiVersion(), parameter, accept, context));
    }

    /**
     * Sets the specified certificate issuer.
     *
     * <p>The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires
     * the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> setCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName,
        String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails,
        IssuerAttributes attributes, Context context) {
        final String accept = "application/json";
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return service.setCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, accept, context);
    }

    /**
     * Sets the specified certificate issuer.
     *
     * <p>The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires
     * the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider,
        IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return setCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials,
            organizationDetails, attributes).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sets the specified certificate issuer.
     *
     * <p>The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires
     * the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider,
        IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes,
        Context context) {
        return setCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials,
            organizationDetails, attributes, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sets the specified certificate issuer.
     *
     * <p>The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires
     * the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IssuerBundle> setCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName,
        String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails,
        IssuerAttributes attributes, Context context) {
        final String accept = "application/json";
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return service.setCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, accept,
            context);
    }

    /**
     * Sets the specified certificate issuer.
     *
     * <p>The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires
     * the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider,
        IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return setCertificateIssuerWithResponse(vaultBaseUrl, issuerName, provider, credentials, organizationDetails,
            attributes, Context.NONE).getValue();
    }

    /**
     * Updates the specified certificate issuer.
     *
     * <p>The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> updateCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName,
        String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails,
        IssuerAttributes attributes) {
        final String accept = "application/json";
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return FluxUtil.withContext(context -> service.updateCertificateIssuer(vaultBaseUrl, issuerName,
            this.getApiVersion(), parameter, accept, context));
    }

    /**
     * Updates the specified certificate issuer.
     *
     * <p>The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> updateCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName,
        String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails,
        IssuerAttributes attributes, Context context) {
        final String accept = "application/json";
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return service.updateCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, accept,
            context);
    }

    /**
     * Updates the specified certificate issuer.
     *
     * <p>The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider,
        IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return updateCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials,
            organizationDetails, attributes).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the specified certificate issuer.
     *
     * <p>The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider,
        IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes,
        Context context) {
        return updateCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, provider, credentials,
            organizationDetails, attributes, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the specified certificate issuer.
     *
     * <p>The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IssuerBundle> updateCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName,
        String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails,
        IssuerAttributes attributes, Context context) {
        final String accept = "application/json";
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.setProvider(provider);
        parameter.setCredentials(credentials);
        parameter.setOrganizationDetails(organizationDetails);
        parameter.setAttributes(attributes);
        return service.updateCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), parameter, accept,
            context);
    }

    /**
     * Updates the specified certificate issuer.
     *
     * <p>The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName, String provider,
        IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return updateCertificateIssuerWithResponse(vaultBaseUrl, issuerName, provider, credentials, organizationDetails,
            attributes, Context.NONE).getValue();
    }

    /**
     * Lists the specified certificate issuer.
     *
     * <p>The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> getCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), accept, context));
    }

    /**
     * Lists the specified certificate issuer.
     *
     * <p>The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> getCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName,
        Context context) {
        final String accept = "application/json";
        return service.getCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the specified certificate issuer.
     *
     * <p>The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return getCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the specified certificate issuer.
     *
     * <p>The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName, Context context) {
        return getCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the specified certificate issuer.
     *
     * <p>The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IssuerBundle> getCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName,
        Context context) {
        final String accept = "application/json";
        return service.getCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the specified certificate issuer.
     *
     * <p>The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key
     * vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IssuerBundle getCertificateIssuer(String vaultBaseUrl, String issuerName) {
        return getCertificateIssuerWithResponse(vaultBaseUrl, issuerName, Context.NONE).getValue();
    }

    /**
     * Deletes the specified certificate issuer.
     *
     * <p>The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault.
     * This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> deleteCertificateIssuerWithResponseAsync(String vaultBaseUrl,
        String issuerName) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteCertificateIssuer(vaultBaseUrl, issuerName,
            this.getApiVersion(), accept, context));
    }

    /**
     * Deletes the specified certificate issuer.
     *
     * <p>The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault.
     * This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IssuerBundle>> deleteCertificateIssuerWithResponseAsync(String vaultBaseUrl, String issuerName,
        Context context) {
        final String accept = "application/json";
        return service.deleteCertificateIssuer(vaultBaseUrl, issuerName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes the specified certificate issuer.
     *
     * <p>The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault.
     * This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return deleteCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes the specified certificate issuer.
     *
     * <p>The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault.
     * This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName, Context context) {
        return deleteCertificateIssuerWithResponseAsync(vaultBaseUrl, issuerName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes the specified certificate issuer.
     *
     * <p>The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault.
     * This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IssuerBundle> deleteCertificateIssuerWithResponse(String vaultBaseUrl, String issuerName,
        Context context) {
        final String accept = "application/json";
        return service.deleteCertificateIssuerSync(vaultBaseUrl, issuerName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes the specified certificate issuer.
     *
     * <p>The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault.
     * This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the issuer for Key Vault certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IssuerBundle deleteCertificateIssuer(String vaultBaseUrl, String issuerName) {
        return deleteCertificateIssuerWithResponse(vaultBaseUrl, issuerName, Context.NONE).getValue();
    }

    /**
     * Creates a new certificate.
     *
     * <p>If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> createCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes,
        Map<String, String> tags) {
        final String accept = "application/json";
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> service.createCertificate(vaultBaseUrl, certificateName,
            this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Creates a new certificate.
     *
     * <p>If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> createCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes,
        Map<String, String> tags, Context context) {
        final String accept = "application/json";
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.createCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Creates a new certificate.
     *
     * <p>If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return createCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy,
            certificateAttributes, tags).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new certificate.
     *
     * <p>If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags,
        Context context) {
        return createCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy,
            certificateAttributes, tags, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new certificate.
     *
     * <p>If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateOperation> createCertificateWithResponse(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags,
        Context context) {
        final String accept = "application/json";
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.createCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Creates a new certificate.
     *
     * <p>If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateOperation createCertificate(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return createCertificateWithResponse(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes,
            tags, Context.NONE).getValue();
    }

    /**
     * Imports a certificate into a specified key vault.
     *
     * <p>Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This
     *     certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> importCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags) {
        final String accept = "application/json";
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.setBase64EncodedCertificate(base64EncodedCertificate);
        parameters.setPassword(password);
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> service.importCertificate(vaultBaseUrl, certificateName,
            this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Imports a certificate into a specified key vault.
     *
     * <p>Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This
     *     certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> importCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        final String accept = "application/json";
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.setBase64EncodedCertificate(base64EncodedCertificate);
        parameters.setPassword(password);
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.importCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Imports a certificate into a specified key vault.
     *
     * <p>Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This
     *     certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName,
        String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return importCertificateWithResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password,
            certificatePolicy, certificateAttributes, tags).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Imports a certificate into a specified key vault.
     *
     * <p>Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This
     *     certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName,
        String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        return importCertificateWithResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password,
            certificatePolicy, certificateAttributes, tags, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Imports a certificate into a specified key vault.
     *
     * <p>Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This
     *     certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateBundle> importCertificateWithResponse(String vaultBaseUrl, String certificateName,
        String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        final String accept = "application/json";
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.setBase64EncodedCertificate(base64EncodedCertificate);
        parameters.setPassword(password);
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.importCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Imports a certificate into a specified key vault.
     *
     * <p>Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     *     of running the service. The value provided should not include personally identifiable or sensitive
     *     information.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This
     *     certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateBundle importCertificate(String vaultBaseUrl, String certificateName,
        String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return importCertificateWithResponse(vaultBaseUrl, certificateName, base64EncodedCertificate, password,
            certificatePolicy, certificateAttributes, tags, Context.NONE).getValue();
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl,
        String certificateName, Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificateVersions(vaultBaseUrl, certificateName, maxresults,
                this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl,
        String certificateName, Integer maxresults, Context context) {
        final String accept = "application/json";
        return service
            .getCertificateVersions(vaultBaseUrl, certificateName, maxresults, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName,
        Integer maxresults) {
        return new PagedFlux<>(() -> getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults),
            nextLink -> getCertificateVersionsNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CertificateItem> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName,
        Integer maxresults, Context context) {
        return new PagedFlux<>(
            () -> getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults, context),
            nextLink -> getCertificateVersionsNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsSinglePage(String vaultBaseUrl, String certificateName,
        Integer maxresults) {
        final String accept = "application/json";
        Response<CertificateListResult> res = service.getCertificateVersionsSync(vaultBaseUrl, certificateName,
            maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsSinglePage(String vaultBaseUrl, String certificateName,
        Integer maxresults, Context context) {
        final String accept = "application/json";
        Response<CertificateListResult> res = service.getCertificateVersionsSync(vaultBaseUrl, certificateName,
            maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName,
        Integer maxresults) {
        return new PagedIterable<>(
            () -> getCertificateVersionsSinglePage(vaultBaseUrl, certificateName, maxresults, Context.NONE),
            nextLink -> getCertificateVersionsNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * List the versions of a certificate.
     *
     * <p>The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName,
        Integer maxresults, Context context) {
        return new PagedIterable<>(
            () -> getCertificateVersionsSinglePage(vaultBaseUrl, certificateName, maxresults, context),
            nextLink -> getCertificateVersionsNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Lists the policy for a certificate.
     *
     * <p>The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key
     * vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponseAsync(String vaultBaseUrl,
        String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificatePolicy(vaultBaseUrl, certificateName,
            this.getApiVersion(), accept, context));
    }

    /**
     * Lists the policy for a certificate.
     *
     * <p>The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key
     * vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponseAsync(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.getCertificatePolicy(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the policy for a certificate.
     *
     * <p>The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key
     * vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName) {
        return getCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the policy for a certificate.
     *
     * <p>The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key
     * vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        return getCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists the policy for a certificate.
     *
     * <p>The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key
     * vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificatePolicy> getCertificatePolicyWithResponse(String vaultBaseUrl, String certificateName,
        Context context) {
        final String accept = "application/json";
        return service.getCertificatePolicySync(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Lists the policy for a certificate.
     *
     * <p>The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key
     * vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificatePolicy getCertificatePolicy(String vaultBaseUrl, String certificateName) {
        return getCertificatePolicyWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    /**
     * Updates the policy for a certificate.
     *
     * <p>Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponseAsync(String vaultBaseUrl,
        String certificateName, CertificatePolicy certificatePolicy) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.updateCertificatePolicy(vaultBaseUrl, certificateName,
            this.getApiVersion(), certificatePolicy, accept, context));
    }

    /**
     * Updates the policy for a certificate.
     *
     * <p>Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponseAsync(String vaultBaseUrl,
        String certificateName, CertificatePolicy certificatePolicy, Context context) {
        final String accept = "application/json";
        return service.updateCertificatePolicy(vaultBaseUrl, certificateName, this.getApiVersion(), certificatePolicy,
            accept, context);
    }

    /**
     * Updates the policy for a certificate.
     *
     * <p>Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy) {
        return updateCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the policy for a certificate.
     *
     * <p>Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy, Context context) {
        return updateCertificatePolicyWithResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the policy for a certificate.
     *
     * <p>Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificatePolicy> updateCertificatePolicyWithResponse(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy, Context context) {
        final String accept = "application/json";
        return service.updateCertificatePolicySync(vaultBaseUrl, certificateName, this.getApiVersion(),
            certificatePolicy, accept, context);
    }

    /**
     * Updates the policy for a certificate.
     *
     * <p>Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return management policy for a certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificatePolicy updateCertificatePolicy(String vaultBaseUrl, String certificateName,
        CertificatePolicy certificatePolicy) {
        return updateCertificatePolicyWithResponse(vaultBaseUrl, certificateName, certificatePolicy, Context.NONE)
            .getValue();
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     *
     * <p>The UpdateCertificate operation applies the specified update on the given certificate; the only elements
     * updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> updateCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, String certificateVersion, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags) {
        final String accept = "application/json";
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> service.updateCertificate(vaultBaseUrl, certificateName,
            certificateVersion, this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     *
     * <p>The UpdateCertificate operation applies the specified update on the given certificate; the only elements
     * updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> updateCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, String certificateVersion, CertificatePolicy certificatePolicy,
        CertificateAttributes certificateAttributes, Map<String, String> tags, Context context) {
        final String accept = "application/json";
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.updateCertificate(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(),
            parameters, accept, context);
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     *
     * <p>The UpdateCertificate operation applies the specified update on the given certificate; the only elements
     * updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName,
        String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes,
        Map<String, String> tags) {
        return updateCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy,
            certificateAttributes, tags).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     *
     * <p>The UpdateCertificate operation applies the specified update on the given certificate; the only elements
     * updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName,
        String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes,
        Map<String, String> tags, Context context) {
        return updateCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy,
            certificateAttributes, tags, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     *
     * <p>The UpdateCertificate operation applies the specified update on the given certificate; the only elements
     * updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateBundle> updateCertificateWithResponse(String vaultBaseUrl, String certificateName,
        String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes,
        Map<String, String> tags, Context context) {
        final String accept = "application/json";
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.setCertificatePolicy(certificatePolicy);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.updateCertificateSync(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(),
            parameters, accept, context);
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     *
     * <p>The UpdateCertificate operation applies the specified update on the given certificate; the only elements
     * updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion,
        CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return updateCertificateWithResponse(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy,
            certificateAttributes, tags, Context.NONE).getValue();
    }

    /**
     * Gets information about a certificate.
     *
     * <p>Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     *     latest version of the certificate is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a specific certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> getCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, String certificateVersion) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificate(vaultBaseUrl, certificateName, certificateVersion,
            this.getApiVersion(), accept, context));
    }

    /**
     * Gets information about a certificate.
     *
     * <p>Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     *     latest version of the certificate is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a specific certificate along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> getCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, String certificateVersion, Context context) {
        final String accept = "application/json";
        return service.getCertificate(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(), accept,
            context);
    }

    /**
     * Gets information about a certificate.
     *
     * <p>Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     *     latest version of the certificate is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a specific certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName,
        String certificateVersion) {
        return getCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets information about a certificate.
     *
     * <p>Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     *     latest version of the certificate is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a specific certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName,
        String certificateVersion, Context context) {
        return getCertificateWithResponseAsync(vaultBaseUrl, certificateName, certificateVersion, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets information about a certificate.
     *
     * <p>Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     *     latest version of the certificate is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a specific certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateBundle> getCertificateWithResponse(String vaultBaseUrl, String certificateName,
        String certificateVersion, Context context) {
        final String accept = "application/json";
        return service.getCertificateSync(vaultBaseUrl, certificateName, certificateVersion, this.getApiVersion(),
            accept, context);
    }

    /**
     * Gets information about a certificate.
     *
     * <p>Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     *     latest version of the certificate is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a specific certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateBundle getCertificate(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return getCertificateWithResponse(vaultBaseUrl, certificateName, certificateVersion, Context.NONE).getValue();
    }

    /**
     * Updates a certificate operation.
     *
     * <p>Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> updateCertificateOperationWithResponseAsync(String vaultBaseUrl,
        String certificateName, boolean cancellationRequested) {
        final String accept = "application/json";
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.setCancellationRequested(cancellationRequested);
        return FluxUtil.withContext(context -> service.updateCertificateOperation(vaultBaseUrl, certificateName,
            this.getApiVersion(), certificateOperation, accept, context));
    }

    /**
     * Updates a certificate operation.
     *
     * <p>Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> updateCertificateOperationWithResponseAsync(String vaultBaseUrl,
        String certificateName, boolean cancellationRequested, Context context) {
        final String accept = "application/json";
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.setCancellationRequested(cancellationRequested);
        return service.updateCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(),
            certificateOperation, accept, context);
    }

    /**
     * Updates a certificate operation.
     *
     * <p>Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName,
        boolean cancellationRequested) {
        return updateCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, cancellationRequested)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates a certificate operation.
     *
     * <p>Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName,
        boolean cancellationRequested, Context context) {
        return updateCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, cancellationRequested,
            context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates a certificate operation.
     *
     * <p>Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateOperation> updateCertificateOperationWithResponse(String vaultBaseUrl,
        String certificateName, boolean cancellationRequested, Context context) {
        final String accept = "application/json";
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.setCancellationRequested(cancellationRequested);
        return service.updateCertificateOperationSync(vaultBaseUrl, certificateName, this.getApiVersion(),
            certificateOperation, accept, context);
    }

    /**
     * Updates a certificate operation.
     *
     * <p>Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateOperation updateCertificateOperation(String vaultBaseUrl, String certificateName,
        boolean cancellationRequested) {
        return updateCertificateOperationWithResponse(vaultBaseUrl, certificateName, cancellationRequested,
            Context.NONE).getValue();
    }

    /**
     * Gets the creation operation of a certificate.
     *
     * <p>Gets the creation operation associated with a specified certificate. This operation requires the
     * certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the creation operation associated with a specified certificate along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> getCertificateOperationWithResponseAsync(String vaultBaseUrl,
        String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificateOperation(vaultBaseUrl, certificateName,
            this.getApiVersion(), accept, context));
    }

    /**
     * Gets the creation operation of a certificate.
     *
     * <p>Gets the creation operation associated with a specified certificate. This operation requires the
     * certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the creation operation associated with a specified certificate along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> getCertificateOperationWithResponseAsync(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.getCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Gets the creation operation of a certificate.
     *
     * <p>Gets the creation operation associated with a specified certificate. This operation requires the
     * certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the creation operation associated with a specified certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return getCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the creation operation of a certificate.
     *
     * <p>Gets the creation operation associated with a specified certificate. This operation requires the
     * certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the creation operation associated with a specified certificate on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        return getCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the creation operation of a certificate.
     *
     * <p>Gets the creation operation associated with a specified certificate. This operation requires the
     * certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the creation operation associated with a specified certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateOperation> getCertificateOperationWithResponse(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.getCertificateOperationSync(vaultBaseUrl, certificateName, this.getApiVersion(), accept,
            context);
    }

    /**
     * Gets the creation operation of a certificate.
     *
     * <p>Gets the creation operation associated with a specified certificate. This operation requires the
     * certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the creation operation associated with a specified certificate.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateOperation getCertificateOperation(String vaultBaseUrl, String certificateName) {
        return getCertificateOperationWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    /**
     * Deletes the creation operation for a specific certificate.
     *
     * <p>Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponseAsync(String vaultBaseUrl,
        String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteCertificateOperation(vaultBaseUrl, certificateName,
            this.getApiVersion(), accept, context));
    }

    /**
     * Deletes the creation operation for a specific certificate.
     *
     * <p>Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponseAsync(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.deleteCertificateOperation(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes the creation operation for a specific certificate.
     *
     * <p>Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return deleteCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes the creation operation for a specific certificate.
     *
     * <p>Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        return deleteCertificateOperationWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes the creation operation for a specific certificate.
     *
     * <p>Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateOperation> deleteCertificateOperationWithResponse(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.deleteCertificateOperationSync(vaultBaseUrl, certificateName, this.getApiVersion(), accept,
            context);
    }

    /**
     * Deletes the creation operation for a specific certificate.
     *
     * <p>Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate operation is returned in case of asynchronous requests.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateOperation deleteCertificateOperation(String vaultBaseUrl, String certificateName) {
        return deleteCertificateOperationWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     *
     * <p>The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> mergeCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes,
        Map<String, String> tags) {
        final String accept = "application/json";
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.setX509Certificates(x509Certificates);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> service.mergeCertificate(vaultBaseUrl, certificateName,
            this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     *
     * <p>The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> mergeCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes,
        Map<String, String> tags, Context context) {
        final String accept = "application/json";
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.setX509Certificates(x509Certificates);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.mergeCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     *
     * <p>The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName,
        List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return mergeCertificateWithResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes,
            tags).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     *
     * <p>The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName,
        List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags,
        Context context) {
        return mergeCertificateWithResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes,
            tags, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     *
     * <p>The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateBundle> mergeCertificateWithResponse(String vaultBaseUrl, String certificateName,
        List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags,
        Context context) {
        final String accept = "application/json";
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.setX509Certificates(x509Certificates);
        parameters.setCertificateAttributes(certificateAttributes);
        parameters.setTags(tags);
        return service.mergeCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), parameters, accept,
            context);
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     *
     * <p>The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName,
        List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return mergeCertificateWithResponse(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes,
            tags, Context.NONE).getValue();
    }

    /**
     * Backs up the specified certificate.
     *
     * <p>Requests that a backup of the specified certificate be downloaded to the client. All versions of the
     * certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup certificate result, containing the backup blob along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupCertificateResult>> backupCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.backupCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context));
    }

    /**
     * Backs up the specified certificate.
     *
     * <p>Requests that a backup of the specified certificate be downloaded to the client. All versions of the
     * certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup certificate result, containing the backup blob along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupCertificateResult>> backupCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.backupCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Backs up the specified certificate.
     *
     * <p>Requests that a backup of the specified certificate be downloaded to the client. All versions of the
     * certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup certificate result, containing the backup blob on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName) {
        return backupCertificateWithResponseAsync(vaultBaseUrl, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Backs up the specified certificate.
     *
     * <p>Requests that a backup of the specified certificate be downloaded to the client. All versions of the
     * certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup certificate result, containing the backup blob on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        return backupCertificateWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Backs up the specified certificate.
     *
     * <p>Requests that a backup of the specified certificate be downloaded to the client. All versions of the
     * certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup certificate result, containing the backup blob along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupCertificateResult> backupCertificateWithResponse(String vaultBaseUrl, String certificateName,
        Context context) {
        final String accept = "application/json";
        return service.backupCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Backs up the specified certificate.
     *
     * <p>Requests that a backup of the specified certificate be downloaded to the client. All versions of the
     * certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup certificate result, containing the backup blob.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupCertificateResult backupCertificate(String vaultBaseUrl, String certificateName) {
        return backupCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    /**
     * Restores a backed up certificate to a vault.
     *
     * <p>Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> restoreCertificateWithResponseAsync(String vaultBaseUrl,
        byte[] certificateBundleBackup) {
        final String accept = "application/json";
        CertificateRestoreParameters parameters = new CertificateRestoreParameters();
        parameters.setCertificateBundleBackup(certificateBundleBackup);
        return FluxUtil.withContext(
            context -> service.restoreCertificate(vaultBaseUrl, this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Restores a backed up certificate to a vault.
     *
     * <p>Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> restoreCertificateWithResponseAsync(String vaultBaseUrl,
        byte[] certificateBundleBackup, Context context) {
        final String accept = "application/json";
        CertificateRestoreParameters parameters = new CertificateRestoreParameters();
        parameters.setCertificateBundleBackup(certificateBundleBackup);
        return service.restoreCertificate(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Restores a backed up certificate to a vault.
     *
     * <p>Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup) {
        return restoreCertificateWithResponseAsync(vaultBaseUrl, certificateBundleBackup)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Restores a backed up certificate to a vault.
     *
     * <p>Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup,
        Context context) {
        return restoreCertificateWithResponseAsync(vaultBaseUrl, certificateBundleBackup, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Restores a backed up certificate to a vault.
     *
     * <p>Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateBundle> restoreCertificateWithResponse(String vaultBaseUrl,
        byte[] certificateBundleBackup, Context context) {
        final String accept = "application/json";
        CertificateRestoreParameters parameters = new CertificateRestoreParameters();
        parameters.setCertificateBundleBackup(certificateBundleBackup);
        return service.restoreCertificateSync(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Restores a backed up certificate to a vault.
     *
     * <p>Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateBundle restoreCertificate(String vaultBaseUrl, byte[] certificateBundleBackup) {
        return restoreCertificateWithResponse(vaultBaseUrl, certificateBundleBackup, Context.NONE).getValue();
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesSinglePageAsync(String vaultBaseUrl,
        Integer maxresults, Boolean includePending) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeletedCertificates(vaultBaseUrl, maxresults, includePending,
                this.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesSinglePageAsync(String vaultBaseUrl,
        Integer maxresults, Boolean includePending, Context context) {
        final String accept = "application/json";
        return service
            .getDeletedCertificates(vaultBaseUrl, maxresults, includePending, this.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificateItem> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults,
        Boolean includePending) {
        return new PagedFlux<>(() -> getDeletedCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending),
            nextLink -> getDeletedCertificatesNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificateItem> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults,
        Boolean includePending, Context context) {
        return new PagedFlux<>(
            () -> getDeletedCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending, context),
            nextLink -> getDeletedCertificatesNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesSinglePage(String vaultBaseUrl,
        Integer maxresults, Boolean includePending) {
        final String accept = "application/json";
        Response<DeletedCertificateListResult> res = service.getDeletedCertificatesSync(vaultBaseUrl, maxresults,
            includePending, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesSinglePage(String vaultBaseUrl,
        Integer maxresults, Boolean includePending, Context context) {
        final String accept = "application/json";
        Response<DeletedCertificateListResult> res = service.getDeletedCertificatesSync(vaultBaseUrl, maxresults,
            includePending, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificateItem> getDeletedCertificates(String vaultBaseUrl, Integer maxresults,
        Boolean includePending) {
        return new PagedIterable<>(
            () -> getDeletedCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, Context.NONE),
            nextLink -> getDeletedCertificatesNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     *
     * <p>The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted
     * state and ready for recovery or purging. This operation includes deletion-specific information. This operation
     * requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificateItem> getDeletedCertificates(String vaultBaseUrl, Integer maxresults,
        Boolean includePending, Context context) {
        return new PagedIterable<>(
            () -> getDeletedCertificatesSinglePage(vaultBaseUrl, maxresults, includePending, context),
            nextLink -> getDeletedCertificatesNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Retrieves information about the specified deleted certificate.
     *
     * <p>The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> getDeletedCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getDeletedCertificate(vaultBaseUrl, certificateName,
            this.getApiVersion(), accept, context));
    }

    /**
     * Retrieves information about the specified deleted certificate.
     *
     * <p>The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedCertificateBundle>> getDeletedCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.getDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Retrieves information about the specified deleted certificate.
     *
     * <p>The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return getDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves information about the specified deleted certificate.
     *
     * <p>The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        return getDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves information about the specified deleted certificate.
     *
     * <p>The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeletedCertificateBundle> getDeletedCertificateWithResponse(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.getDeletedCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Retrieves information about the specified deleted certificate.
     *
     * <p>The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     *     when it will be purged.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeletedCertificateBundle getDeletedCertificate(String vaultBaseUrl, String certificateName) {
        return getDeletedCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    /**
     * Permanently deletes the specified deleted certificate.
     *
     * <p>The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.purgeDeletedCertificate(vaultBaseUrl, certificateName,
            this.getApiVersion(), accept, context));
    }

    /**
     * Permanently deletes the specified deleted certificate.
     *
     * <p>The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponseAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        final String accept = "application/json";
        return service.purgeDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Permanently deletes the specified deleted certificate.
     *
     * <p>The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return purgeDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Permanently deletes the specified deleted certificate.
     *
     * <p>The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName, Context context) {
        return purgeDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Permanently deletes the specified deleted certificate.
     *
     * <p>The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String vaultBaseUrl, String certificateName,
        Context context) {
        final String accept = "application/json";
        return service.purgeDeletedCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), accept,
            context);
    }

    /**
     * Permanently deletes the specified deleted certificate.
     *
     * <p>The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purgeDeletedCertificate(String vaultBaseUrl, String certificateName) {
        purgeDeletedCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE);
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     *
     * <p>The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> recoverDeletedCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.recoverDeletedCertificate(vaultBaseUrl, certificateName,
            this.getApiVersion(), accept, context));
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     *
     * <p>The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CertificateBundle>> recoverDeletedCertificateWithResponseAsync(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.recoverDeletedCertificate(vaultBaseUrl, certificateName, this.getApiVersion(), accept, context);
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     *
     * <p>The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return recoverDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     *
     * <p>The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName,
        Context context) {
        return recoverDeletedCertificateWithResponseAsync(vaultBaseUrl, certificateName, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     *
     * <p>The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CertificateBundle> recoverDeletedCertificateWithResponse(String vaultBaseUrl,
        String certificateName, Context context) {
        final String accept = "application/json";
        return service.recoverDeletedCertificateSync(vaultBaseUrl, certificateName, this.getApiVersion(), accept,
            context);
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     *
     * <p>The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CertificateBundle recoverDeletedCertificate(String vaultBaseUrl, String certificateName) {
        return recoverDeletedCertificateWithResponse(vaultBaseUrl, certificateName, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesNextSinglePageAsync(String nextLink,
        String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificatesNext(nextLink, vaultBaseUrl, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificatesNextSinglePageAsync(String nextLink, String vaultBaseUrl,
        Context context) {
        final String accept = "application/json";
        return service.getCertificatesNext(nextLink, vaultBaseUrl, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<CertificateListResult> res
            = service.getCertificatesNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificatesNextSinglePage(String nextLink, String vaultBaseUrl,
        Context context) {
        final String accept = "application/json";
        Response<CertificateListResult> res = service.getCertificatesNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersNextSinglePageAsync(String nextLink,
        String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificateIssuersNext(nextLink, vaultBaseUrl, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateIssuerItem>> getCertificateIssuersNextSinglePageAsync(String nextLink,
        String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getCertificateIssuersNext(nextLink, vaultBaseUrl, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersNextSinglePage(String nextLink,
        String vaultBaseUrl) {
        final String accept = "application/json";
        Response<CertificateIssuerListResult> res
            = service.getCertificateIssuersNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate issuer list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateIssuerItem> getCertificateIssuersNextSinglePage(String nextLink,
        String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<CertificateIssuerListResult> res
            = service.getCertificateIssuersNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsNextSinglePageAsync(String nextLink,
        String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificateVersionsNext(nextLink, vaultBaseUrl, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CertificateItem>> getCertificateVersionsNextSinglePageAsync(String nextLink,
        String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getCertificateVersionsNext(nextLink, vaultBaseUrl, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<CertificateListResult> res
            = service.getCertificateVersionsNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CertificateItem> getCertificateVersionsNextSinglePage(String nextLink, String vaultBaseUrl,
        Context context) {
        final String accept = "application/json";
        Response<CertificateListResult> res
            = service.getCertificateVersionsNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesNextSinglePageAsync(String nextLink,
        String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeletedCertificatesNext(nextLink, vaultBaseUrl, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedCertificateItem>> getDeletedCertificatesNextSinglePageAsync(String nextLink,
        String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getDeletedCertificatesNext(nextLink, vaultBaseUrl, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesNextSinglePage(String nextLink,
        String vaultBaseUrl) {
        final String accept = "application/json";
        Response<DeletedCertificateListResult> res
            = service.getDeletedCertificatesNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedCertificateItem> getDeletedCertificatesNextSinglePage(String nextLink,
        String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<DeletedCertificateListResult> res
            = service.getDeletedCertificatesNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }
}
