// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** The certificate operation update parameters. */
@Fluent
public final class CertificateOperationUpdateParameter
    implements JsonSerializable<CertificateOperationUpdateParameter> {
    /*
     * Indicates if cancellation was requested on the certificate operation.
     */
    private boolean cancellationRequested;

    /** Creates an instance of CertificateOperationUpdateParameter class. */
    public CertificateOperationUpdateParameter() {
    }

    /**
     * Get the cancellationRequested property: Indicates if cancellation was requested on the certificate operation.
     *
     * @return the cancellationRequested value.
     */
    public boolean isCancellationRequested() {
        return this.cancellationRequested;
    }

    /**
     * Set the cancellationRequested property: Indicates if cancellation was requested on the certificate operation.
     *
     * @param cancellationRequested the cancellationRequested value to set.
     * @return the CertificateOperationUpdateParameter object itself.
     */
    public CertificateOperationUpdateParameter setCancellationRequested(boolean cancellationRequested) {
        this.cancellationRequested = cancellationRequested;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("cancellation_requested", this.cancellationRequested);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateOperationUpdateParameter from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateOperationUpdateParameter if the JsonReader was pointing to an instance of it,
     *     or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateOperationUpdateParameter.
     */
    public static CertificateOperationUpdateParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateOperationUpdateParameter deserializedCertificateOperationUpdateParameter
                = new CertificateOperationUpdateParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cancellation_requested".equals(fieldName)) {
                    deserializedCertificateOperationUpdateParameter.cancellationRequested = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateOperationUpdateParameter;
        });
    }
}
