// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/** The certificate restore parameters. */
@Fluent
public final class CertificateRestoreParameters implements JsonSerializable<CertificateRestoreParameters> {
    /*
     * The backup blob associated with a certificate bundle.
     */
    private Base64Url certificateBundleBackup;

    /** Creates an instance of CertificateRestoreParameters class. */
    public CertificateRestoreParameters() {
    }

    /**
     * Get the certificateBundleBackup property: The backup blob associated with a certificate bundle.
     *
     * @return the certificateBundleBackup value.
     */
    public byte[] getCertificateBundleBackup() {
        if (this.certificateBundleBackup == null) {
            return null;
        }
        return this.certificateBundleBackup.decodedBytes();
    }

    /**
     * Set the certificateBundleBackup property: The backup blob associated with a certificate bundle.
     *
     * @param certificateBundleBackup the certificateBundleBackup value to set.
     * @return the CertificateRestoreParameters object itself.
     */
    public CertificateRestoreParameters setCertificateBundleBackup(byte[] certificateBundleBackup) {
        if (certificateBundleBackup == null) {
            this.certificateBundleBackup = null;
        } else {
            this.certificateBundleBackup = Base64Url.encode(CoreUtils.clone(certificateBundleBackup));
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.certificateBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateRestoreParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateRestoreParameters if the JsonReader was pointing to an instance of it, or null
     *     if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateRestoreParameters.
     */
    public static CertificateRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateRestoreParameters deserializedCertificateRestoreParameters = new CertificateRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedCertificateRestoreParameters.certificateBundleBackup
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateRestoreParameters;
        });
    }
}
