// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** Parameters for the issuer of the X509 component of a certificate. */
@Fluent
public final class IssuerParameters implements JsonSerializable<IssuerParameters> {
    /*
     * Name of the referenced issuer object or reserved names; for example, 'Self' or 'Unknown'.
     */
    private String name;

    /*
     * Certificate type as supported by the provider (optional); for example 'OV-SSL', 'EV-SSL'
     */
    private String certificateType;

    /*
     * Indicates if the certificates generated under this policy should be published to certificate transparency logs.
     */
    private Boolean certificateTransparency;

    /** Creates an instance of IssuerParameters class. */
    public IssuerParameters() {
    }

    /**
     * Get the name property: Name of the referenced issuer object or reserved names; for example, 'Self' or 'Unknown'.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Name of the referenced issuer object or reserved names; for example, 'Self' or 'Unknown'.
     *
     * @param name the name value to set.
     * @return the IssuerParameters object itself.
     */
    public IssuerParameters setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the certificateType property: Certificate type as supported by the provider (optional); for example 'OV-SSL',
     * 'EV-SSL'.
     *
     * @return the certificateType value.
     */
    public String getCertificateType() {
        return this.certificateType;
    }

    /**
     * Set the certificateType property: Certificate type as supported by the provider (optional); for example 'OV-SSL',
     * 'EV-SSL'.
     *
     * @param certificateType the certificateType value to set.
     * @return the IssuerParameters object itself.
     */
    public IssuerParameters setCertificateType(String certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    /**
     * Get the certificateTransparency property: Indicates if the certificates generated under this policy should be
     * published to certificate transparency logs.
     *
     * @return the certificateTransparency value.
     */
    public Boolean isCertificateTransparency() {
        return this.certificateTransparency;
    }

    /**
     * Set the certificateTransparency property: Indicates if the certificates generated under this policy should be
     * published to certificate transparency logs.
     *
     * @param certificateTransparency the certificateTransparency value to set.
     * @return the IssuerParameters object itself.
     */
    public IssuerParameters setCertificateTransparency(Boolean certificateTransparency) {
        this.certificateTransparency = certificateTransparency;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("cty", this.certificateType);
        jsonWriter.writeBooleanField("cert_transparency", this.certificateTransparency);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IssuerParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of IssuerParameters if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the IssuerParameters.
     */
    public static IssuerParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IssuerParameters deserializedIssuerParameters = new IssuerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedIssuerParameters.name = reader.getString();
                } else if ("cty".equals(fieldName)) {
                    deserializedIssuerParameters.certificateType = reader.getString();
                } else if ("cert_transparency".equals(fieldName)) {
                    deserializedIssuerParameters.certificateTransparency = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIssuerParameters;
        });
    }
}
