// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A certificate bundle consists of a certificate (X509) plus its attributes.
 */
@Fluent
public class CertificateBundle implements JsonSerializable<CertificateBundle> {
    /*
     * The certificate id.
     */
    private String id;

    /*
     * The key id.
     */
    private String kid;

    /*
     * The secret id.
     */
    private String sid;

    /*
     * Thumbprint of the certificate.
     */
    private Base64Url x509Thumbprint;

    /*
     * The management policy.
     */
    private CertificatePolicy policy;

    /*
     * CER contents of x509 certificate.
     */
    private byte[] cer;

    /*
     * The content type of the secret. eg. 'application/x-pem-file' or 'application/x-pkcs12',
     */
    private String contentType;

    /*
     * The certificate attributes.
     */
    private CertificateAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of CertificateBundle class.
     */
    public CertificateBundle() {
    }

    /**
     * Get the id property: The certificate id.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: The certificate id.
     * 
     * @param id the id value to set.
     * @return the CertificateBundle object itself.
     */
    CertificateBundle setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the kid property: The key id.
     * 
     * @return the kid value.
     */
    public String getKid() {
        return this.kid;
    }

    /**
     * Set the kid property: The key id.
     * 
     * @param kid the kid value to set.
     * @return the CertificateBundle object itself.
     */
    CertificateBundle setKid(String kid) {
        this.kid = kid;
        return this;
    }

    /**
     * Get the sid property: The secret id.
     * 
     * @return the sid value.
     */
    public String getSid() {
        return this.sid;
    }

    /**
     * Set the sid property: The secret id.
     * 
     * @param sid the sid value to set.
     * @return the CertificateBundle object itself.
     */
    CertificateBundle setSid(String sid) {
        this.sid = sid;
        return this;
    }

    /**
     * Get the x509Thumbprint property: Thumbprint of the certificate.
     * 
     * @return the x509Thumbprint value.
     */
    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    /**
     * Set the x509Thumbprint property: Thumbprint of the certificate.
     * 
     * @param x509Thumbprint the x509Thumbprint value to set.
     * @return the CertificateBundle object itself.
     */
    CertificateBundle setX509Thumbprint(byte[] x509Thumbprint) {
        if (x509Thumbprint == null) {
            this.x509Thumbprint = null;
        } else {
            this.x509Thumbprint = Base64Url.encode(CoreUtils.clone(x509Thumbprint));
        }
        return this;
    }

    /**
     * Get the policy property: The management policy.
     * 
     * @return the policy value.
     */
    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    /**
     * Set the policy property: The management policy.
     * 
     * @param policy the policy value to set.
     * @return the CertificateBundle object itself.
     */
    CertificateBundle setPolicy(CertificatePolicy policy) {
        this.policy = policy;
        return this;
    }

    /**
     * Get the cer property: CER contents of x509 certificate.
     * 
     * @return the cer value.
     */
    public byte[] getCer() {
        return CoreUtils.clone(this.cer);
    }

    /**
     * Set the cer property: CER contents of x509 certificate.
     * 
     * @param cer the cer value to set.
     * @return the CertificateBundle object itself.
     */
    public CertificateBundle setCer(byte[] cer) {
        this.cer = CoreUtils.clone(cer);
        return this;
    }

    /**
     * Get the contentType property: The content type of the secret. eg. 'application/x-pem-file' or
     * 'application/x-pkcs12',.
     * 
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The content type of the secret. eg. 'application/x-pem-file' or
     * 'application/x-pkcs12',.
     * 
     * @param contentType the contentType value to set.
     * @return the CertificateBundle object itself.
     */
    public CertificateBundle setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the attributes property: The certificate attributes.
     * 
     * @return the attributes value.
     */
    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The certificate attributes.
     * 
     * @param attributes the attributes value to set.
     * @return the CertificateBundle object itself.
     */
    public CertificateBundle setAttributes(CertificateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the CertificateBundle object itself.
     */
    public CertificateBundle setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", this.cer);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateBundle from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateBundle if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateBundle.
     */
    public static CertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateBundle deserializedCertificateBundle = new CertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCertificateBundle.id = reader.getString();
                } else if ("kid".equals(fieldName)) {
                    deserializedCertificateBundle.kid = reader.getString();
                } else if ("sid".equals(fieldName)) {
                    deserializedCertificateBundle.sid = reader.getString();
                } else if ("x5t".equals(fieldName)) {
                    deserializedCertificateBundle.x509Thumbprint
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("policy".equals(fieldName)) {
                    deserializedCertificateBundle.policy = CertificatePolicy.fromJson(reader);
                } else if ("cer".equals(fieldName)) {
                    deserializedCertificateBundle.cer = reader.getBinary();
                } else if ("contentType".equals(fieldName)) {
                    deserializedCertificateBundle.contentType = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedCertificateBundle.attributes = CertificateAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCertificateBundle.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateBundle;
        });
    }
}
