// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/**
 * A Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on when it will
 * be purged.
 */
@Fluent
public final class DeletedCertificateBundle extends CertificateBundle {
    /*
     * The url of the recovery object, used to identify and recover the deleted certificate.
     */
    private String recoveryId;

    /*
     * The time when the certificate is scheduled to be purged, in UTC
     */
    private Long scheduledPurgeDate;

    /*
     * The time when the certificate was deleted, in UTC
     */
    private Long deletedDate;

    /*
     * The management policy.
     */
    private CertificatePolicy policy;

    /*
     * Thumbprint of the certificate.
     */
    private Base64Url x509Thumbprint;

    /*
     * The secret id.
     */
    private String sid;

    /*
     * The key id.
     */
    private String kid;

    /*
     * The certificate id.
     */
    private String id;

    /**
     * Creates an instance of DeletedCertificateBundle class.
     */
    public DeletedCertificateBundle() {
    }

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted
     * certificate.
     * 
     * @return the recoveryId value.
     */
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Set the recoveryId property: The url of the recovery object, used to identify and recover the deleted
     * certificate.
     * 
     * @param recoveryId the recoveryId value to set.
     * @return the DeletedCertificateBundle object itself.
     */
    public DeletedCertificateBundle setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the certificate is scheduled to be purged, in UTC.
     * 
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the certificate was deleted, in UTC.
     * 
     * @return the deletedDate value.
     */
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /**
     * Get the policy property: The management policy.
     * 
     * @return the policy value.
     */
    @Override
    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    /**
     * Get the x509Thumbprint property: Thumbprint of the certificate.
     * 
     * @return the x509Thumbprint value.
     */
    @Override
    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    /**
     * Get the sid property: The secret id.
     * 
     * @return the sid value.
     */
    @Override
    public String getSid() {
        return this.sid;
    }

    /**
     * Get the kid property: The key id.
     * 
     * @return the kid value.
     */
    @Override
    public String getKid() {
        return this.kid;
    }

    /**
     * Get the id property: The certificate id.
     * 
     * @return the id value.
     */
    @Override
    public String getId() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateBundle setCer(byte[] cer) {
        super.setCer(cer);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateBundle setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateBundle setAttributes(CertificateAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateBundle setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", getCer());
        jsonWriter.writeStringField("contentType", getContentType());
        jsonWriter.writeJsonField("attributes", getAttributes());
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedCertificateBundle from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedCertificateBundle if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedCertificateBundle.
     */
    public static DeletedCertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedCertificateBundle deserializedDeletedCertificateBundle = new DeletedCertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.id = reader.getString();
                } else if ("kid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.kid = reader.getString();
                } else if ("sid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.sid = reader.getString();
                } else if ("x5t".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.x509Thumbprint
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("policy".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.policy = CertificatePolicy.fromJson(reader);
                } else if ("cer".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setCer(reader.getBinary());
                } else if ("contentType".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setContentType(reader.getString());
                } else if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setAttributes(CertificateAttributes.fromJson(reader));
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedCertificateBundle.setTags(tags);
                } else if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.recoveryId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                } else if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.deletedDate = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedCertificateBundle;
        });
    }
}
