// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

/**
 * The deleted certificate item containing metadata about the deleted certificate.
 */
@Fluent
public final class DeletedCertificateItem extends CertificateItem {
    /*
     * The url of the recovery object, used to identify and recover the deleted certificate.
     */
    private String recoveryId;

    /*
     * The time when the certificate is scheduled to be purged, in UTC
     */
    private Long scheduledPurgeDate;

    /*
     * The time when the certificate was deleted, in UTC
     */
    private Long deletedDate;

    /**
     * Creates an instance of DeletedCertificateItem class.
     */
    public DeletedCertificateItem() {
    }

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted
     * certificate.
     * 
     * @return the recoveryId value.
     */
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Set the recoveryId property: The url of the recovery object, used to identify and recover the deleted
     * certificate.
     * 
     * @param recoveryId the recoveryId value to set.
     * @return the DeletedCertificateItem object itself.
     */
    public DeletedCertificateItem setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the certificate is scheduled to be purged, in UTC.
     * 
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the certificate was deleted, in UTC.
     * 
     * @return the deletedDate value.
     */
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateItem setId(String id) {
        super.setId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateItem setAttributes(CertificateAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateItem setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeletedCertificateItem setX509Thumbprint(byte[] x509Thumbprint) {
        super.setX509Thumbprint(x509Thumbprint);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeJsonField("attributes", getAttributes());
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        if (getX509Thumbprint() != null) {
            jsonWriter.writeStringField("x5t", Objects.toString(Base64Url.encode(getX509Thumbprint()), null));
        }
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedCertificateItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedCertificateItem if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedCertificateItem.
     */
    public static DeletedCertificateItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedCertificateItem deserializedDeletedCertificateItem = new DeletedCertificateItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateItem.setId(reader.getString());
                } else if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateItem.setAttributes(CertificateAttributes.fromJson(reader));
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedCertificateItem.setTags(tags);
                } else if ("x5t".equals(fieldName)) {
                    Base64Url x509ThumbprintHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (x509ThumbprintHolder != null) {
                        deserializedDeletedCertificateItem.setX509Thumbprint(x509ThumbprintHolder.decodedBytes());
                    }
                } else if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateItem.recoveryId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                } else if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.deletedDate = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedCertificateItem;
        });
    }
}
