// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.AdministratorContact;
import java.io.IOException;
import java.util.List;

/**
 * Details of the organization of the certificate issuer.
 */
@Fluent
public final class OrganizationDetails implements JsonSerializable<OrganizationDetails> {
    /*
     * Id of the organization.
     */
    private String id;

    /*
     * Details of the organization administrator.
     */
    private List<AdministratorContact> adminDetails;

    /**
     * Creates an instance of OrganizationDetails class.
     */
    public OrganizationDetails() {
    }

    /**
     * Get the id property: Id of the organization.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Id of the organization.
     * 
     * @param id the id value to set.
     * @return the OrganizationDetails object itself.
     */
    public OrganizationDetails setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the adminDetails property: Details of the organization administrator.
     * 
     * @return the adminDetails value.
     */
    public List<AdministratorContact> getAdminDetails() {
        return this.adminDetails;
    }

    /**
     * Set the adminDetails property: Details of the organization administrator.
     * 
     * @param adminDetails the adminDetails value to set.
     * @return the OrganizationDetails object itself.
     */
    public OrganizationDetails setAdminDetails(List<AdministratorContact> adminDetails) {
        this.adminDetails = adminDetails;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeArrayField("admin_details", this.adminDetails, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OrganizationDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OrganizationDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OrganizationDetails.
     */
    public static OrganizationDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrganizationDetails deserializedOrganizationDetails = new OrganizationDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedOrganizationDetails.id = reader.getString();
                } else if ("admin_details".equals(fieldName)) {
                    List<AdministratorContact> adminDetails
                        = reader.readArray(reader1 -> AdministratorContact.fromJson(reader1));
                    deserializedOrganizationDetails.adminDetails = adminDetails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOrganizationDetails;
        });
    }
}
