// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The subject alternate names of a X509 object.
 */
@Fluent
public final class SubjectAlternativeNames implements JsonSerializable<SubjectAlternativeNames> {
    /*
     * Email addresses.
     */
    private List<String> emails;

    /*
     * Domain names.
     */
    private List<String> dnsNames;

    /*
     * User principal names.
     */
    private List<String> userPrincipalNames;

    /**
     * Creates an instance of SubjectAlternativeNames class.
     */
    public SubjectAlternativeNames() {
    }

    /**
     * Get the emails property: Email addresses.
     * 
     * @return the emails value.
     */
    public List<String> getEmails() {
        return this.emails;
    }

    /**
     * Set the emails property: Email addresses.
     * 
     * @param emails the emails value to set.
     * @return the SubjectAlternativeNames object itself.
     */
    public SubjectAlternativeNames setEmails(List<String> emails) {
        this.emails = emails;
        return this;
    }

    /**
     * Get the dnsNames property: Domain names.
     * 
     * @return the dnsNames value.
     */
    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    /**
     * Set the dnsNames property: Domain names.
     * 
     * @param dnsNames the dnsNames value to set.
     * @return the SubjectAlternativeNames object itself.
     */
    public SubjectAlternativeNames setDnsNames(List<String> dnsNames) {
        this.dnsNames = dnsNames;
        return this;
    }

    /**
     * Get the userPrincipalNames property: User principal names.
     * 
     * @return the userPrincipalNames value.
     */
    public List<String> getUserPrincipalNames() {
        return this.userPrincipalNames;
    }

    /**
     * Set the userPrincipalNames property: User principal names.
     * 
     * @param userPrincipalNames the userPrincipalNames value to set.
     * @return the SubjectAlternativeNames object itself.
     */
    public SubjectAlternativeNames setUserPrincipalNames(List<String> userPrincipalNames) {
        this.userPrincipalNames = userPrincipalNames;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("emails", this.emails, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("dns_names", this.dnsNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("upns", this.userPrincipalNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubjectAlternativeNames from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubjectAlternativeNames if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubjectAlternativeNames.
     */
    public static SubjectAlternativeNames fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubjectAlternativeNames deserializedSubjectAlternativeNames = new SubjectAlternativeNames();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("emails".equals(fieldName)) {
                    List<String> emails = reader.readArray(reader1 -> reader1.getString());
                    deserializedSubjectAlternativeNames.emails = emails;
                } else if ("dns_names".equals(fieldName)) {
                    List<String> dnsNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedSubjectAlternativeNames.dnsNames = dnsNames;
                } else if ("upns".equals(fieldName)) {
                    List<String> userPrincipalNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedSubjectAlternativeNames.userPrincipalNames = userPrincipalNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubjectAlternativeNames;
        });
    }
}
