// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.CertificateOperationError;
import java.io.IOException;

/**
 * A certificate operation is returned in case of asynchronous requests.
 */
@Fluent
public final class CertificateOperation implements JsonSerializable<CertificateOperation> {
    /*
     * The certificate id.
     */
    private String id;

    /*
     * Parameters for the issuer of the X509 component of a certificate.
     */
    private IssuerParameters issuerParameters;

    /*
     * The certificate signing request (CSR) that is being used in the certificate operation.
     */
    private byte[] csr;

    /*
     * Indicates if cancellation was requested on the certificate operation.
     */
    private Boolean cancellationRequested;

    /*
     * Status of the certificate operation.
     */
    private String status;

    /*
     * The status details of the certificate operation.
     */
    private String statusDetails;

    /*
     * Error encountered, if any, during the certificate operation.
     */
    private CertificateOperationError error;

    /*
     * Location which contains the result of the certificate operation.
     */
    private String target;

    /*
     * Identifier for the certificate operation.
     */
    private String requestId;

    /**
     * Creates an instance of CertificateOperation class.
     */
    public CertificateOperation() {
    }

    /**
     * Get the id property: The certificate id.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the issuerParameters property: Parameters for the issuer of the X509 component of a certificate.
     * 
     * @return the issuerParameters value.
     */
    public IssuerParameters getIssuerParameters() {
        return this.issuerParameters;
    }

    /**
     * Set the issuerParameters property: Parameters for the issuer of the X509 component of a certificate.
     * 
     * @param issuerParameters the issuerParameters value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setIssuerParameters(IssuerParameters issuerParameters) {
        this.issuerParameters = issuerParameters;
        return this;
    }

    /**
     * Get the csr property: The certificate signing request (CSR) that is being used in the certificate operation.
     * 
     * @return the csr value.
     */
    public byte[] getCsr() {
        return CoreUtils.clone(this.csr);
    }

    /**
     * Set the csr property: The certificate signing request (CSR) that is being used in the certificate operation.
     * 
     * @param csr the csr value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setCsr(byte[] csr) {
        this.csr = CoreUtils.clone(csr);
        return this;
    }

    /**
     * Get the cancellationRequested property: Indicates if cancellation was requested on the certificate operation.
     * 
     * @return the cancellationRequested value.
     */
    public Boolean isCancellationRequested() {
        return this.cancellationRequested;
    }

    /**
     * Set the cancellationRequested property: Indicates if cancellation was requested on the certificate operation.
     * 
     * @param cancellationRequested the cancellationRequested value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setCancellationRequested(Boolean cancellationRequested) {
        this.cancellationRequested = cancellationRequested;
        return this;
    }

    /**
     * Get the status property: Status of the certificate operation.
     * 
     * @return the status value.
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Status of the certificate operation.
     * 
     * @param status the status value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the statusDetails property: The status details of the certificate operation.
     * 
     * @return the statusDetails value.
     */
    public String getStatusDetails() {
        return this.statusDetails;
    }

    /**
     * Set the statusDetails property: The status details of the certificate operation.
     * 
     * @param statusDetails the statusDetails value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    /**
     * Get the error property: Error encountered, if any, during the certificate operation.
     * 
     * @return the error value.
     */
    public CertificateOperationError getError() {
        return this.error;
    }

    /**
     * Set the error property: Error encountered, if any, during the certificate operation.
     * 
     * @param error the error value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setError(CertificateOperationError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the target property: Location which contains the result of the certificate operation.
     * 
     * @return the target value.
     */
    public String getTarget() {
        return this.target;
    }

    /**
     * Set the target property: Location which contains the result of the certificate operation.
     * 
     * @param target the target value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the requestId property: Identifier for the certificate operation.
     * 
     * @return the requestId value.
     */
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * Set the requestId property: Identifier for the certificate operation.
     * 
     * @param requestId the requestId value to set.
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("issuer", this.issuerParameters);
        jsonWriter.writeBinaryField("csr", this.csr);
        jsonWriter.writeBooleanField("cancellation_requested", this.cancellationRequested);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("status_details", this.statusDetails);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeStringField("request_id", this.requestId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateOperation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateOperation if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateOperation.
     */
    public static CertificateOperation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateOperation deserializedCertificateOperation = new CertificateOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCertificateOperation.id = reader.getString();
                } else if ("issuer".equals(fieldName)) {
                    deserializedCertificateOperation.issuerParameters = IssuerParameters.fromJson(reader);
                } else if ("csr".equals(fieldName)) {
                    deserializedCertificateOperation.csr = reader.getBinary();
                } else if ("cancellation_requested".equals(fieldName)) {
                    deserializedCertificateOperation.cancellationRequested = reader.getNullable(JsonReader::getBoolean);
                } else if ("status".equals(fieldName)) {
                    deserializedCertificateOperation.status = reader.getString();
                } else if ("status_details".equals(fieldName)) {
                    deserializedCertificateOperation.statusDetails = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedCertificateOperation.error = CertificateOperationError.fromJson(reader);
                } else if ("target".equals(fieldName)) {
                    deserializedCertificateOperation.target = reader.getString();
                } else if ("request_id".equals(fieldName)) {
                    deserializedCertificateOperation.requestId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateOperation;
        });
    }
}
