// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.CertificateKeyUsage;
import com.azure.security.keyvault.certificates.models.SubjectAlternativeNames;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the X509 component of a certificate.
 */
@Fluent
public final class X509CertificateProperties implements JsonSerializable<X509CertificateProperties> {
    /*
     * The subject name. Should be a valid X509 distinguished Name.
     */
    private String subject;

    /*
     * The enhanced key usage.
     */
    private List<String> ekus;

    /*
     * The subject alternative names.
     */
    private SubjectAlternativeNames subjectAlternativeNames;

    /*
     * Defines how the certificate's key may be used.
     */
    private List<CertificateKeyUsage> keyUsage;

    /*
     * The duration that the certificate is valid in months.
     */
    private Integer validityInMonths;

    /**
     * Creates an instance of X509CertificateProperties class.
     */
    public X509CertificateProperties() {
    }

    /**
     * Get the subject property: The subject name. Should be a valid X509 distinguished Name.
     * 
     * @return the subject value.
     */
    public String getSubject() {
        return this.subject;
    }

    /**
     * Set the subject property: The subject name. Should be a valid X509 distinguished Name.
     * 
     * @param subject the subject value to set.
     * @return the X509CertificateProperties object itself.
     */
    public X509CertificateProperties setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the ekus property: The enhanced key usage.
     * 
     * @return the ekus value.
     */
    public List<String> getEkus() {
        return this.ekus;
    }

    /**
     * Set the ekus property: The enhanced key usage.
     * 
     * @param ekus the ekus value to set.
     * @return the X509CertificateProperties object itself.
     */
    public X509CertificateProperties setEkus(List<String> ekus) {
        this.ekus = ekus;
        return this;
    }

    /**
     * Get the subjectAlternativeNames property: The subject alternative names.
     * 
     * @return the subjectAlternativeNames value.
     */
    public SubjectAlternativeNames getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    /**
     * Set the subjectAlternativeNames property: The subject alternative names.
     * 
     * @param subjectAlternativeNames the subjectAlternativeNames value to set.
     * @return the X509CertificateProperties object itself.
     */
    public X509CertificateProperties setSubjectAlternativeNames(SubjectAlternativeNames subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    /**
     * Get the keyUsage property: Defines how the certificate's key may be used.
     * 
     * @return the keyUsage value.
     */
    public List<CertificateKeyUsage> getKeyUsage() {
        return this.keyUsage;
    }

    /**
     * Set the keyUsage property: Defines how the certificate's key may be used.
     * 
     * @param keyUsage the keyUsage value to set.
     * @return the X509CertificateProperties object itself.
     */
    public X509CertificateProperties setKeyUsage(List<CertificateKeyUsage> keyUsage) {
        this.keyUsage = keyUsage;
        return this;
    }

    /**
     * Get the validityInMonths property: The duration that the certificate is valid in months.
     * 
     * @return the validityInMonths value.
     */
    public Integer getValidityInMonths() {
        return this.validityInMonths;
    }

    /**
     * Set the validityInMonths property: The duration that the certificate is valid in months.
     * 
     * @param validityInMonths the validityInMonths value to set.
     * @return the X509CertificateProperties object itself.
     */
    public X509CertificateProperties setValidityInMonths(Integer validityInMonths) {
        this.validityInMonths = validityInMonths;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeArrayField("ekus", this.ekus, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sans", this.subjectAlternativeNames);
        jsonWriter.writeArrayField("key_usage", this.keyUsage,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("validity_months", this.validityInMonths);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of X509CertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of X509CertificateProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the X509CertificateProperties.
     */
    public static X509CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            X509CertificateProperties deserializedX509CertificateProperties = new X509CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subject".equals(fieldName)) {
                    deserializedX509CertificateProperties.subject = reader.getString();
                } else if ("ekus".equals(fieldName)) {
                    List<String> ekus = reader.readArray(reader1 -> reader1.getString());
                    deserializedX509CertificateProperties.ekus = ekus;
                } else if ("sans".equals(fieldName)) {
                    deserializedX509CertificateProperties.subjectAlternativeNames
                        = SubjectAlternativeNames.fromJson(reader);
                } else if ("key_usage".equals(fieldName)) {
                    List<CertificateKeyUsage> keyUsage
                        = reader.readArray(reader1 -> CertificateKeyUsage.fromString(reader1.getString()));
                    deserializedX509CertificateProperties.keyUsage = keyUsage;
                } else if ("validity_months".equals(fieldName)) {
                    deserializedX509CertificateProperties.validityInMonths = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedX509CertificateProperties;
        });
    }
}
