/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.Attributes;
import com.azure.security.keyvault.certificates.implementation.models.DeletionRecoveryLevel;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class CertificateAttributes
extends Attributes {
    private Integer recoverableDays;
    private DeletionRecoveryLevel recoveryLevel;
    private Long updated;
    private Long created;

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public DeletionRecoveryLevel getRecoveryLevel() {
        return this.recoveryLevel;
    }

    @Override
    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    @Override
    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    @Override
    public CertificateAttributes setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public CertificateAttributes setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    @Override
    public CertificateAttributes setExpires(OffsetDateTime expires) {
        super.setExpires(expires);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.isEnabled());
        if (this.getNotBefore() != null) {
            jsonWriter.writeNumberField("nbf", (Number)this.getNotBefore().toEpochSecond());
        }
        if (this.getExpires() != null) {
            jsonWriter.writeNumberField("exp", (Number)this.getExpires().toEpochSecond());
        }
        return jsonWriter.writeEndObject();
    }

    public static CertificateAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateAttributes)jsonReader.readObject(reader -> {
            CertificateAttributes deserializedCertificateAttributes = new CertificateAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedCertificateAttributes.setEnabled((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    Long notBeforeHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (notBeforeHolder == null) continue;
                    deserializedCertificateAttributes.setNotBefore(OffsetDateTime.ofInstant(Instant.ofEpochSecond(notBeforeHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    Long expiresHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (expiresHolder == null) continue;
                    deserializedCertificateAttributes.setExpires(OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedCertificateAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedCertificateAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    deserializedCertificateAttributes.recoverableDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("recoveryLevel".equals(fieldName)) {
                    deserializedCertificateAttributes.recoveryLevel = DeletionRecoveryLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateAttributes;
        });
    }
}

