/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.implementation.CertificateClientImpl;
import com.azure.security.keyvault.certificates.implementation.CertificateIssuerHelper;
import com.azure.security.keyvault.certificates.implementation.CertificateOperationHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyHelper;
import com.azure.security.keyvault.certificates.implementation.CertificatePropertiesHelper;
import com.azure.security.keyvault.certificates.implementation.DeletedCertificateHelper;
import com.azure.security.keyvault.certificates.implementation.IssuerPropertiesHelper;
import com.azure.security.keyvault.certificates.implementation.KeyVaultCertificateWithPolicyHelper;
import com.azure.security.keyvault.certificates.implementation.models.BackupCertificateResult;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.CertificateCreateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateImportParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerSetParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.CertificateMergeParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateOperationUpdateParameter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateRestoreParameters;
import com.azure.security.keyvault.certificates.implementation.models.CertificateUpdateParameters;
import com.azure.security.keyvault.certificates.implementation.models.Contacts;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateItem;
import com.azure.security.keyvault.certificates.implementation.models.IssuerBundle;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateContentType;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CertificateClientBuilder.class, isAsync=true, serviceInterfaces={CertificateClientImpl.CertificateClientService.class})
public final class CertificateAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateAsyncClient.class);
    static final RequestOptions EMPTY_OPTIONS = new RequestOptions();
    private final CertificateClientImpl implClient;
    private final String vaultUrl;

    CertificateAsyncClient(CertificateClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        return this.beginCreateCertificate(certificateName, policy, isEnabled, tags, false);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags, Boolean preserveCertificateOrder) {
        try {
            if (policy == null) {
                return PollerFlux.error((Exception)LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null.")));
            }
            return new PollerFlux(Duration.ofSeconds(1L), ignored -> this.createCertificateActivation(certificateName, policy, isEnabled, tags, preserveCertificateOrder), ignored -> this.certificatePollOperation(certificateName), (ignored1, ignored2) -> this.certificateCancellationOperation(certificateName), ignored -> this.fetchCertificateOperation(certificateName));
        }
        catch (RuntimeException e) {
            return PollerFlux.error((Exception)e);
        }
    }

    private Mono<CertificateOperation> createCertificateActivation(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags, Boolean isCertificateOrderPreserved) {
        CertificateCreateParameters certificateCreateParameters = new CertificateCreateParameters().setCertificatePolicy(CertificatePolicyHelper.getImplCertificatePolicy(policy)).setCertificateAttributes(new CertificateAttributes().setEnabled(isEnabled)).setTags(tags).setPreserveCertOrder(isCertificateOrderPreserved);
        try {
            return this.implClient.createCertificateWithResponseAsync(certificateName, BinaryData.fromObject((Object)certificateCreateParameters), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapCreateCertificateException).flatMap(FluxUtil::toMono).map(binaryData -> CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)binaryData.toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapCreateCertificateException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    private Mono<PollResponse<CertificateOperation>> certificatePollOperation(String certificateName) {
        return this.implClient.getCertificateOperationWithResponseAsync(certificateName, EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapGetCertificateOperationException).flatMap(FluxUtil::toMono).map(binaryData -> CertificateAsyncClient.processCertificateOperationResponse((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)binaryData.toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class)));
    }

    static HttpResponseException mapGetCertificateOperationException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    static PollResponse<CertificateOperation> processCertificateOperationResponse(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation impl) {
        return new PollResponse(CertificateAsyncClient.mapStatus(impl.getStatus()), (Object)CertificateOperationHelper.createCertificateOperation(impl));
    }

    private static LongRunningOperationStatus mapStatus(String status) {
        switch (status) {
            case "inProgress": {
                return LongRunningOperationStatus.IN_PROGRESS;
            }
            case "completed": {
                return LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
            }
            case "failed": {
                return LongRunningOperationStatus.FAILED;
            }
        }
        return LongRunningOperationStatus.fromString((String)status, (boolean)true);
    }

    private Mono<CertificateOperation> certificateCancellationOperation(String certificateName) {
        CertificateOperationUpdateParameter certificateOperationUpdateParameter = new CertificateOperationUpdateParameter(true);
        return this.implClient.updateCertificateOperationWithResponseAsync(certificateName, BinaryData.fromObject((Object)certificateOperationUpdateParameter), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapUpdateCertificateOperationException).flatMap(FluxUtil::toMono).map(binaryData -> CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)binaryData.toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class)));
    }

    static HttpResponseException mapUpdateCertificateOperationException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    private Mono<KeyVaultCertificateWithPolicy> fetchCertificateOperation(String certificateName) {
        return this.implClient.getCertificateWithResponseAsync(certificateName, null, EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapGetCertificateException).flatMap(FluxUtil::toMono).map(binaryData -> KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)binaryData.toObject(CertificateBundle.class)));
    }

    static HttpResponseException mapGetCertificateException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 403 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy) {
        return this.beginCreateCertificate(certificateName, policy, true, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        try {
            return new PollerFlux(Duration.ofSeconds(1L), pollingContext -> Mono.empty(), ignored -> this.certificatePollOperation(certificateName), (ignored1, ignored2) -> this.certificateCancellationOperation(certificateName), ignored -> this.fetchCertificateOperation(certificateName));
        }
        catch (RuntimeException e) {
            return PollerFlux.error((Exception)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> getCertificate(String certificateName) {
        return this.getCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> getCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.getCertificateWithResponseAsync(certificateName, null, EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapGetCertificateException).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificate>> getCertificateVersionWithResponse(String certificateName, String version) {
        try {
            return this.implClient.getCertificateWithResponseAsync(certificateName, version, EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapGetCertificateException).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> getCertificateVersion(String certificateName, String version) {
        return this.getCertificateVersionWithResponse(certificateName, version).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> updateCertificateProperties(CertificateProperties properties) {
        return this.updateCertificatePropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificate>> updateCertificatePropertiesWithResponse(CertificateProperties properties) {
        if (properties == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'properties' cannot be null."));
        }
        try {
            CertificateAttributes certificateAttributes = new CertificateAttributes().setEnabled(properties.isEnabled()).setExpires(properties.getExpiresOn()).setNotBefore(properties.getNotBefore());
            CertificateUpdateParameters certificateUpdateParameters = new CertificateUpdateParameters().setCertificateAttributes(certificateAttributes).setTags(properties.getTags());
            return this.implClient.updateCertificateWithResponseAsync(properties.getName(), properties.getVersion(), BinaryData.fromObject((Object)certificateUpdateParameters), EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        try {
            return new PollerFlux(Duration.ofSeconds(1L), ignored -> this.deleteCertificateActivation(certificateName), pollingContext -> this.deleteCertificatePollOperation(certificateName, (PollingContext<DeletedCertificate>)pollingContext), (pollingContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
        }
        catch (RuntimeException e) {
            return PollerFlux.error((Exception)e);
        }
    }

    private Mono<DeletedCertificate> deleteCertificateActivation(String certificateName) {
        return this.implClient.deleteCertificateWithResponseAsync(certificateName, EMPTY_OPTIONS).flatMap(FluxUtil::toMono).map(binaryData -> DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateBundle)binaryData.toObject(DeletedCertificateBundle.class)));
    }

    static HttpResponseException mapDeleteCertificateException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    private Mono<PollResponse<DeletedCertificate>> deleteCertificatePollOperation(String certificateName, PollingContext<DeletedCertificate> pollingContext) {
        return this.implClient.getDeletedCertificateWithResponseAsync(certificateName, EMPTY_OPTIONS).flatMap(FluxUtil::toMono).map(binaryData -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateBundle)binaryData.toObject(DeletedCertificateBundle.class)))).onErrorResume(HttpResponseException.class, e -> {
            if (e.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedCertificate)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedCertificate> getDeletedCertificate(String certificateName) {
        return this.getDeletedCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedCertificate>> getDeletedCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.getDeletedCertificateWithResponseAsync(certificateName, EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateBundle)((BinaryData)response.getValue()).toObject(DeletedCertificateBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedCertificate(String certificateName) {
        return this.purgeDeletedCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.purgeDeletedCertificateWithResponseAsync(certificateName, EMPTY_OPTIONS);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return new PollerFlux(Duration.ofSeconds(1L), ignored -> this.recoverDeletedCertificateActivation(certificateName), pollingContext -> this.recoverDeletedCertificatePollOperation(certificateName, (PollingContext<KeyVaultCertificateWithPolicy>)pollingContext), (pollingContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
    }

    private Mono<KeyVaultCertificateWithPolicy> recoverDeletedCertificateActivation(String certificateName) {
        try {
            return this.implClient.recoverDeletedCertificateWithResponseAsync(certificateName, EMPTY_OPTIONS).flatMap(FluxUtil::toMono).map(binaryData -> KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)binaryData.toObject(CertificateBundle.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private Mono<PollResponse<KeyVaultCertificateWithPolicy>> recoverDeletedCertificatePollOperation(String certificateName, PollingContext<KeyVaultCertificateWithPolicy> pollingContext) {
        return this.implClient.getCertificateWithResponseAsync(certificateName, null, EMPTY_OPTIONS).flatMap(FluxUtil::toMono).map(binaryData -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)binaryData.toObject(CertificateBundle.class)))).onErrorResume(HttpResponseException.class, e -> {
            if (e.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultCertificateWithPolicy)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupCertificate(String certificateName) {
        return this.backupCertificateWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupCertificateWithResponse(String certificateName) {
        try {
            return this.implClient.backupCertificateWithResponseAsync(certificateName, EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)((BackupCertificateResult)((BinaryData)response.getValue()).toObject(BackupCertificateResult.class)).getValue()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> restoreCertificateBackup(byte[] backup) {
        return this.restoreCertificateBackupWithResponse(backup).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> restoreCertificateBackupWithResponse(byte[] backup) {
        try {
            CertificateRestoreParameters certificateRestoreParameters = new CertificateRestoreParameters(backup);
            return this.implClient.restoreCertificateWithResponseAsync(BinaryData.fromObject((Object)certificateRestoreParameters), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapRestoreCertificateException).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapRestoreCertificateException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificates(boolean includePending) {
        try {
            RequestOptions requestOptions = new RequestOptions().addQueryParam("includePending", String.valueOf(includePending), false);
            PagedFlux<BinaryData> pagedFluxResponse = this.implClient.getCertificatesAsync(requestOptions);
            return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
                Flux pagedResponseFlux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
                return pagedResponseFlux.map(pagedResponse -> CertificateAsyncClient.mapPagedResponse(pagedResponse, binaryData -> CertificatePropertiesHelper.createCertificateProperties((CertificateItem)binaryData.toObject(CertificateItem.class))));
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificates() {
        return this.listPropertiesOfCertificates(false);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificate> listDeletedCertificates() {
        return this.listDeletedCertificates(false);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedCertificate> listDeletedCertificates(boolean includePending) {
        try {
            RequestOptions requestOptions = new RequestOptions().addQueryParam("includePending", String.valueOf(includePending), false);
            PagedFlux<BinaryData> pagedFluxResponse = this.implClient.getDeletedCertificatesAsync(requestOptions);
            return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
                Flux pagedResponseFlux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
                return pagedResponseFlux.map(pagedResponse -> CertificateAsyncClient.mapPagedResponse(pagedResponse, binaryData -> DeletedCertificateHelper.createDeletedCertificate((DeletedCertificateItem)binaryData.toObject(DeletedCertificateItem.class))));
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        try {
            PagedFlux<BinaryData> pagedFluxResponse = this.implClient.getCertificateVersionsAsync(certificateName, EMPTY_OPTIONS);
            return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
                Flux pagedResponseFlux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
                return pagedResponseFlux.map(pagedResponse -> CertificateAsyncClient.mapPagedResponse(pagedResponse, binaryData -> CertificatePropertiesHelper.createCertificateProperties((CertificateItem)binaryData.toObject(CertificateItem.class))));
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private static <T, R> PagedResponse<R> mapPagedResponse(PagedResponse<T> page, Function<T, R> itemMapper) {
        ArrayList<R> mappedValues = new ArrayList<R>(page.getValue().size());
        for (Object item : page.getValue()) {
            mappedValues.add(itemMapper.apply(item));
        }
        return new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), mappedValues, (String)page.getContinuationToken(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificate> mergeCertificate(MergeCertificateOptions mergeCertificateOptions) {
        return this.mergeCertificateWithResponse(mergeCertificateOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions) {
        if (mergeCertificateOptions == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'mergeCertificateOptions' cannot be null."));
        }
        try {
            CertificateMergeParameters certificateMergeParameters = new CertificateMergeParameters(mergeCertificateOptions.getX509Certificates()).setCertificateAttributes(new CertificateAttributes().setEnabled(mergeCertificateOptions.isEnabled())).setTags(mergeCertificateOptions.getTags());
            return this.implClient.mergeCertificateWithResponseAsync(mergeCertificateOptions.getName(), BinaryData.fromObject((Object)certificateMergeParameters), EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> getCertificatePolicy(String certificateName) {
        return this.getCertificatePolicyWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> getCertificatePolicyWithResponse(String certificateName) {
        try {
            return this.implClient.getCertificatePolicyWithResponseAsync(certificateName, EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapGetCertificatePolicyException).map(response -> new SimpleResponse(response, (Object)CertificatePolicyHelper.createCertificatePolicy((com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapGetCertificatePolicyException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 403 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificatePolicy> updateCertificatePolicy(String certificateName, CertificatePolicy policy) {
        return this.updateCertificatePolicyWithResponse(certificateName, policy).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificatePolicy>> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy) {
        if (policy == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        try {
            return this.implClient.updateCertificatePolicyWithResponseAsync(certificateName, BinaryData.fromObject((Object)CertificatePolicyHelper.getImplCertificatePolicy(policy)), EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)CertificatePolicyHelper.createCertificatePolicy((com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> createIssuer(CertificateIssuer issuer) {
        return this.createIssuerWithResponse(issuer).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> createIssuerWithResponse(CertificateIssuer issuer) {
        if (issuer == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        try {
            IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
            CertificateIssuerSetParameters certificateIssuerSetParameters = new CertificateIssuerSetParameters(issuer.getProvider()).setAttributes(issuerBundle.getAttributes()).setCredentials(issuerBundle.getCredentials()).setOrganizationDetails(issuerBundle.getOrganizationDetails());
            return this.implClient.setCertificateIssuerWithResponseAsync(issuer.getName(), BinaryData.fromObject((Object)certificateIssuerSetParameters), EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> getIssuerWithResponse(String issuerName) {
        try {
            return this.implClient.getCertificateIssuerWithResponseAsync(issuerName, EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> getIssuer(String issuerName) {
        return this.getIssuerWithResponse(issuerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> deleteIssuerWithResponse(String issuerName) {
        try {
            return this.implClient.deleteCertificateIssuerWithResponseAsync(issuerName, EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> deleteIssuer(String issuerName) {
        return this.deleteIssuerWithResponse(issuerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IssuerProperties> listPropertiesOfIssuers() {
        try {
            PagedFlux<BinaryData> pagedFluxResponse = this.implClient.getCertificateIssuersAsync(EMPTY_OPTIONS);
            return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
                Flux pagedResponseFlux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
                return pagedResponseFlux.map(pagedResponse -> CertificateAsyncClient.mapPagedResponse(pagedResponse, binaryData -> IssuerPropertiesHelper.createIssuerProperties((CertificateIssuerItem)binaryData.toObject(CertificateIssuerItem.class))));
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateIssuer> updateIssuer(CertificateIssuer issuer) {
        return this.updateIssuerWithResponse(issuer).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateIssuer>> updateIssuerWithResponse(CertificateIssuer issuer) {
        if (issuer == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'issuer' cannot be null."));
        }
        try {
            IssuerBundle issuerBundle = CertificateIssuerHelper.getIssuerBundle(issuer);
            CertificateIssuerUpdateParameters certificateIssuerUpdateParameters = new CertificateIssuerUpdateParameters().setProvider(issuer.getProvider()).setAttributes(issuerBundle.getAttributes()).setCredentials(issuerBundle.getCredentials()).setOrganizationDetails(issuerBundle.getOrganizationDetails());
            return this.implClient.updateCertificateIssuerWithResponseAsync(issuer.getName(), BinaryData.fromObject((Object)certificateIssuerUpdateParameters), EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)CertificateIssuerHelper.createCertificateIssuer((IssuerBundle)((BinaryData)response.getValue()).toObject(IssuerBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> setContacts(List<CertificateContact> contacts) {
        return new PagedFlux(() -> this.implClient.setCertificateContactsWithResponseAsync(BinaryData.fromObject((Object)new Contacts().setContactList(contacts)), EMPTY_OPTIONS).map(CertificateAsyncClient::mapContactsToPagedResponse));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> listContacts() {
        return new PagedFlux(() -> this.implClient.getCertificateContactsWithResponseAsync(EMPTY_OPTIONS).map(CertificateAsyncClient::mapContactsToPagedResponse));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CertificateContact> deleteContacts() {
        return new PagedFlux(() -> this.implClient.deleteCertificateContactsWithResponseAsync(EMPTY_OPTIONS).map(CertificateAsyncClient::mapContactsToPagedResponse));
    }

    static PagedResponse<CertificateContact> mapContactsToPagedResponse(Response<BinaryData> response) {
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((Contacts)((BinaryData)response.getValue()).toObject(Contacts.class)).getContactList(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> deleteCertificateOperation(String certificateName) {
        return this.deleteCertificateOperationWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> deleteCertificateOperationWithResponse(String certificateName) {
        try {
            return this.implClient.deleteCertificateOperationWithResponseAsync(certificateName, EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapDeleteCertificateOperationException(HttpResponseException e) {
        return e.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(e.getMessage(), e.getResponse(), e.getValue()) : e;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CertificateOperation> cancelCertificateOperation(String certificateName) {
        return this.cancelCertificateOperationWithResponse(certificateName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CertificateOperation>> cancelCertificateOperationWithResponse(String certificateName) {
        try {
            CertificateOperationUpdateParameter certificateOperationUpdateParameter = new CertificateOperationUpdateParameter(true);
            return this.implClient.updateCertificateOperationWithResponseAsync(certificateName, BinaryData.fromObject((Object)certificateOperationUpdateParameter), EMPTY_OPTIONS).onErrorMap(HttpResponseException.class, CertificateAsyncClient::mapUpdateCertificateOperationException).map(response -> new SimpleResponse(response, (Object)CertificateOperationHelper.createCertificateOperation((com.azure.security.keyvault.certificates.implementation.models.CertificateOperation)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.certificates.implementation.models.CertificateOperation.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultCertificateWithPolicy> importCertificate(ImportCertificateOptions importCertificateOptions) {
        return this.importCertificateWithResponse(importCertificateOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultCertificateWithPolicy>> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions) {
        if (importCertificateOptions == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'importCertificateOptions' cannot be null."));
        }
        try {
            CertificateImportParameters certificateImportParameters = new CertificateImportParameters(CertificateAsyncClient.transformCertificateForImport(importCertificateOptions)).setCertificatePolicy(CertificatePolicyHelper.getImplCertificatePolicy(importCertificateOptions.getPolicy())).setPassword(importCertificateOptions.getPassword()).setTags(importCertificateOptions.getTags()).setCertificateAttributes(new CertificateAttributes().setEnabled(importCertificateOptions.isEnabled())).setPreserveCertOrder(importCertificateOptions.isCertificateOrderPreserved());
            return this.implClient.importCertificateWithResponseAsync(importCertificateOptions.getName(), BinaryData.fromObject((Object)certificateImportParameters), EMPTY_OPTIONS).map(response -> new SimpleResponse(response, (Object)KeyVaultCertificateWithPolicyHelper.createCertificateWithPolicy((CertificateBundle)((BinaryData)response.getValue()).toObject(CertificateBundle.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static String transformCertificateForImport(ImportCertificateOptions options) {
        CertificatePolicy policy = options.getPolicy();
        return policy != null && CertificateContentType.PEM.equals((Object)policy.getContentType()) ? new String(options.getCertificate(), StandardCharsets.US_ASCII) : Base64.getEncoder().encodeToString(options.getCertificate());
    }
}

