/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import java.util.Map;
import java.util.Objects;

public final class ImportCertificateOptions {
    private final byte[] certificate;
    private final String name;
    private String password;
    private Boolean enabled;
    private CertificatePolicy policy;
    private Map<String, String> tags;
    private Boolean certificateOrderPreserved;

    public ImportCertificateOptions(String name, byte[] certificate) {
        Objects.requireNonNull(certificate, "The certificate parameter cannot be null.");
        this.name = name;
        this.certificate = CoreUtils.clone((byte[])certificate);
    }

    public ImportCertificateOptions setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    public ImportCertificateOptions setPolicy(CertificatePolicy policy) {
        this.policy = policy;
        return this;
    }

    public ImportCertificateOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public ImportCertificateOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getCertificate() {
        return CoreUtils.clone((byte[])this.certificate);
    }

    public ImportCertificateOptions setCertificateOrderPreserved(Boolean certificateOrderPreserved) {
        this.certificateOrderPreserved = certificateOrderPreserved;
        return this;
    }

    public Boolean isCertificateOrderPreserved() {
        return this.certificateOrderPreserved;
    }
}

