// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.certificates.CertificateServiceVersion;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the CertificateClient type.
 */
public final class CertificateClientImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CertificateClientService service;

    /**
     */
    private final String vaultBaseUrl;

    /**
     * Gets.
     * 
     * @return the vaultBaseUrl value.
     */
    public String getVaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    /**
     * Service version.
     */
    private final CertificateServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public CertificateServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of CertificateClient client.
     * 
     * @param vaultBaseUrl
     * @param serviceVersion Service version.
     */
    public CertificateClientImpl(String vaultBaseUrl, CertificateServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    /**
     * Initializes an instance of CertificateClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param vaultBaseUrl
     * @param serviceVersion Service version.
     */
    public CertificateClientImpl(HttpPipeline httpPipeline, String vaultBaseUrl,
        CertificateServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    /**
     * Initializes an instance of CertificateClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param vaultBaseUrl
     * @param serviceVersion Service version.
     */
    public CertificateClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String vaultBaseUrl,
        CertificateServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.vaultBaseUrl = vaultBaseUrl;
        this.serviceVersion = serviceVersion;
        this.service = RestProxy.create(CertificateClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for CertificateClient to be used by the proxy service to perform REST
     * calls.
     */
    @Host("{vaultBaseUrl}")
    @ServiceInterface(name = "CertificateClient")
    public interface CertificateClientService {
        @Get("/certificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificates(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/certificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificatesSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Delete("/certificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/certificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Put("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> setCertificateContacts(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData contacts,
            RequestOptions requestOptions, Context context);

        @Put("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> setCertificateContactsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData contacts,
            RequestOptions requestOptions, Context context);

        @Get("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificateContacts(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateContactsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Delete("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteCertificateContacts(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Delete("/certificates/contacts")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteCertificateContactsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/certificates/issuers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificateIssuers(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/certificates/issuers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateIssuersSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Put("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> setCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameter, RequestOptions requestOptions, Context context);

        @Put("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> setCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameter, RequestOptions requestOptions, Context context);

        @Patch("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameter, RequestOptions requestOptions, Context context);

        @Patch("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameter, RequestOptions requestOptions, Context context);

        @Get("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteCertificateIssuer(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/certificates/issuers/{issuer-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteCertificateIssuerSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("issuer-name") String issuerName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/create")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/create")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/import")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> importCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/import")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> importCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Get("/certificates/{certificate-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificateVersions(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/certificates/{certificate-name}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateVersionsSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificatePolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificatePolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Patch("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateCertificatePolicy(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData certificatePolicy, RequestOptions requestOptions,
            Context context);

        @Patch("/certificates/{certificate-name}/policy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateCertificatePolicySync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData certificatePolicy, RequestOptions requestOptions,
            Context context);

        @Patch("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Patch("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Get("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @PathParam("certificate-version") String certificateVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Patch("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateCertificateOperation(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData certificateOperation, RequestOptions requestOptions,
            Context context);

        @Patch("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateCertificateOperationSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData certificateOperation, RequestOptions requestOptions,
            Context context);

        @Get("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificateOperation(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateOperationSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteCertificateOperation(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/certificates/{certificate-name}/pending")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteCertificateOperationSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> mergeCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> mergeCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData parameters, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> backupCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/certificates/{certificate-name}/backup")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> backupCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/certificates/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> restoreCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Post("/certificates/restore")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> restoreCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData parameters,
            RequestOptions requestOptions, Context context);

        @Get("/deletedcertificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeletedCertificates(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/deletedcertificates")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getDeletedCertificatesSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeletedCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getDeletedCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> purgeDeletedCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/deletedcertificates/{certificate-name}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> purgeDeletedCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> recoverDeletedCertificate(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> recoverDeletedCertificateSync(@HostParam("vaultBaseUrl") String vaultBaseUrl,
            @QueryParam("api-version") String apiVersion, @PathParam("certificate-name") String certificateName,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificatesNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificatesNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificateIssuersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateIssuersNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getCertificateVersionsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getCertificateVersionsNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeletedCertificatesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getDeletedCertificatesNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("vaultBaseUrl") String vaultBaseUrl, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);
    }

    /**
     * List certificates in a specified key vault
     * 
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificatesSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificates(this.getVaultBaseUrl(),
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List certificates in a specified key vault
     * 
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getCertificatesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> getCertificatesSinglePageAsync(requestOptions),
            nextLink -> getCertificatesNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List certificates in a specified key vault
     * 
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificatesSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getCertificatesSync(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List certificates in a specified key vault
     * 
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getCertificates(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> getCertificatesSinglePage(requestOptions),
            nextLink -> getCertificatesNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Deletes a certificate from a specified key vault.
     * 
     * Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be used
     * to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     * when it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteCertificate(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Deletes a certificate from a specified key vault.
     * 
     * Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be used
     * to remove individual versions of a certificate object. This operation requires the certificates/delete
     * permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     * when it will be purged along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     * 
     * Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param contacts The contacts for the key vault certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> setCertificateContactsWithResponseAsync(BinaryData contacts,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.setCertificateContacts(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), contentType, accept, contacts, requestOptions, context));
    }

    /**
     * Sets the certificate contacts for the specified key vault.
     * 
     * Sets the certificate contacts for the specified key vault. This operation requires the
     * certificates/managecontacts permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param contacts The contacts for the key vault certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the contacts for the vault certificates along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> setCertificateContactsWithResponse(BinaryData contacts, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.setCertificateContactsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            contentType, accept, contacts, requestOptions, Context.NONE);
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     * 
     * The GetCertificateContacts operation returns the set of certificate contact resources in the specified key vault.
     * This operation requires the certificates/managecontacts permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateContactsWithResponseAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificateContacts(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), accept, requestOptions, context));
    }

    /**
     * Lists the certificate contacts for a specified key vault.
     * 
     * The GetCertificateContacts operation returns the set of certificate contact resources in the specified key vault.
     * This operation requires the certificates/managecontacts permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the contacts for the vault certificates along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCertificateContactsWithResponse(RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getCertificateContactsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), accept,
            requestOptions, Context.NONE);
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     * 
     * Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the contacts for the vault certificates along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateContactsWithResponseAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteCertificateContacts(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), accept, requestOptions, context));
    }

    /**
     * Deletes the certificate contacts for a specified key vault.
     * 
     * Deletes the certificate contacts for a specified key vault certificate. This operation requires the
     * certificates/managecontacts permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     contacts (Optional): [
     *          (Optional){
     *             email: String (Optional)
     *             name: String (Optional)
     *             phone: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the contacts for the vault certificates along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateContactsWithResponse(RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteCertificateContactsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            accept, requestOptions, Context.NONE);
    }

    /**
     * List certificate issuers for a specified key vault.
     * 
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault.
     * This operation requires the certificates/manageissuers/getissuers permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate issuer list result along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateIssuersSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificateIssuers(this.getVaultBaseUrl(),
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List certificate issuers for a specified key vault.
     * 
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault.
     * This operation requires the certificates/manageissuers/getissuers permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate issuer list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getCertificateIssuersAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> getCertificateIssuersSinglePageAsync(requestOptions),
            nextLink -> getCertificateIssuersNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List certificate issuers for a specified key vault.
     * 
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault.
     * This operation requires the certificates/manageissuers/getissuers permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate issuer list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateIssuersSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getCertificateIssuersSync(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List certificate issuers for a specified key vault.
     * 
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault.
     * This operation requires the certificates/manageissuers/getissuers permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate issuer list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getCertificateIssuers(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> getCertificateIssuersSinglePage(requestOptions),
            nextLink -> getCertificateIssuersNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Sets the specified certificate issuer.
     * 
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the
     * certificates/setissuers permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     provider: String (Required)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     * the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameter Certificate issuer set parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> setCertificateIssuerWithResponseAsync(String issuerName, BinaryData parameter,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.setCertificateIssuer(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                issuerName, contentType, accept, parameter, requestOptions, context));
    }

    /**
     * Sets the specified certificate issuer.
     * 
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the
     * certificates/setissuers permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     provider: String (Required)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer. The value you provide may be copied globally for the purpose of running
     * the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameter Certificate issuer set parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> setCertificateIssuerWithResponse(String issuerName, BinaryData parameter,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.setCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            issuerName, contentType, accept, parameter, requestOptions, Context.NONE);
    }

    /**
     * Updates the specified certificate issuer.
     * 
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer.
     * @param parameter Certificate issuer update parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificateIssuerWithResponseAsync(String issuerName, BinaryData parameter,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.updateCertificateIssuer(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                issuerName, contentType, accept, parameter, requestOptions, context));
    }

    /**
     * Updates the specified certificate issuer.
     * 
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This
     * operation requires the certificates/setissuers permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer.
     * @param parameter Certificate issuer update parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateCertificateIssuerWithResponse(String issuerName, BinaryData parameter,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            issuerName, contentType, accept, parameter, requestOptions, Context.NONE);
    }

    /**
     * Lists the specified certificate issuer.
     * 
     * The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key vault.
     * This operation requires the certificates/manageissuers/getissuers permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateIssuerWithResponseAsync(String issuerName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificateIssuer(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), issuerName, accept, requestOptions, context));
    }

    /**
     * Lists the specified certificate issuer.
     * 
     * The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key vault.
     * This operation requires the certificates/manageissuers/getissuers permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCertificateIssuerWithResponse(String issuerName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            issuerName, accept, requestOptions, Context.NONE);
    }

    /**
     * Deletes the specified certificate issuer.
     * 
     * The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault. This
     * operation requires the certificates/manageissuers/deleteissuers permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateIssuerWithResponseAsync(String issuerName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteCertificateIssuer(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), issuerName, accept, requestOptions, context));
    }

    /**
     * Deletes the specified certificate issuer.
     * 
     * The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault. This
     * operation requires the certificates/manageissuers/deleteissuers permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     *     credentials (Optional): {
     *         account_id: String (Optional)
     *         pwd: String (Optional)
     *     }
     *     org_details (Optional): {
     *         id: String (Optional)
     *         admin_details (Optional): [
     *              (Optional){
     *                 first_name: String (Optional)
     *                 last_name: String (Optional)
     *                 email: String (Optional)
     *                 phone: String (Optional)
     *             }
     *         ]
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param issuerName The name of the issuer.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the issuer for Key Vault certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateIssuerWithResponse(String issuerName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            issuerName, accept, requestOptions, Context.NONE);
    }

    /**
     * Creates a new certificate.
     * 
     * If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     * of running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters to create a certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createCertificateWithResponseAsync(String certificateName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.createCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                certificateName, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Creates a new certificate.
     * 
     * If this is the first version, the certificate resource is created. This operation requires the
     * certificates/create permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     * of running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters to create a certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createCertificateWithResponse(String certificateName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Imports a certificate into a specified key vault.
     * 
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: String (Required)
     *     pwd: String (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     * of running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters to import the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> importCertificateWithResponseAsync(String certificateName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.importCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                certificateName, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Imports a certificate into a specified key vault.
     * 
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires
     * the certificates/import permission. The certificate to be imported can be in either PFX or PEM format. If the
     * certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key Vault will only
     * accept a key in PKCS#8 format.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: String (Required)
     *     pwd: String (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate. The value you provide may be copied globally for the purpose
     * of running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters to import the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> importCertificateWithResponse(String certificateName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.importCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * List the versions of a certificate.
     * 
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateVersionsSinglePageAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificateVersions(this.getVaultBaseUrl(),
                this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List the versions of a certificate.
     * 
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getCertificateVersionsAsync(String certificateName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> getCertificateVersionsSinglePageAsync(certificateName, requestOptions),
            nextLink -> getCertificateVersionsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List the versions of a certificate.
     * 
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateVersionsSinglePage(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getCertificateVersionsSync(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List the versions of a certificate.
     * 
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This
     * operation requires the certificates/list permission.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getCertificateVersions(String certificateName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> getCertificateVersionsSinglePage(certificateName, requestOptions),
            nextLink -> getCertificateVersionsNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Lists the policy for a certificate.
     * 
     * The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key vault.
     * This operation requires the certificates/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     key_props (Optional): {
     *         exportable: Boolean (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_size: Integer (Optional)
     *         reuse_key: Boolean (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     }
     *     secret_props (Optional): {
     *         contentType: String (Optional)
     *     }
     *     x509_props (Optional): {
     *         subject: String (Optional)
     *         ekus (Optional): [
     *             String (Optional)
     *         ]
     *         sans (Optional): {
     *             emails (Optional): [
     *                 String (Optional)
     *             ]
     *             dns_names (Optional): [
     *                 String (Optional)
     *             ]
     *             upns (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *         key_usage (Optional): [
     *             String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *         ]
     *         validity_months: Integer (Optional)
     *     }
     *     lifetime_actions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 lifetime_percentage: Integer (Optional)
     *                 days_before_expiry: Integer (Optional)
     *             }
     *             action (Optional): {
     *                 action_type: String(EmailContacts/AutoRenew) (Optional)
     *             }
     *         }
     *     ]
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in a given key vault.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a certificate along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificatePolicyWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificatePolicy(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Lists the policy for a certificate.
     * 
     * The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key vault.
     * This operation requires the certificates/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     key_props (Optional): {
     *         exportable: Boolean (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_size: Integer (Optional)
     *         reuse_key: Boolean (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     }
     *     secret_props (Optional): {
     *         contentType: String (Optional)
     *     }
     *     x509_props (Optional): {
     *         subject: String (Optional)
     *         ekus (Optional): [
     *             String (Optional)
     *         ]
     *         sans (Optional): {
     *             emails (Optional): [
     *                 String (Optional)
     *             ]
     *             dns_names (Optional): [
     *                 String (Optional)
     *             ]
     *             upns (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *         key_usage (Optional): [
     *             String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *         ]
     *         validity_months: Integer (Optional)
     *     }
     *     lifetime_actions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 lifetime_percentage: Integer (Optional)
     *                 days_before_expiry: Integer (Optional)
     *             }
     *             action (Optional): {
     *                 action_type: String(EmailContacts/AutoRenew) (Optional)
     *             }
     *         }
     *     ]
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in a given key vault.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCertificatePolicyWithResponse(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getCertificatePolicySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * Updates the policy for a certificate.
     * 
     * Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     key_props (Optional): {
     *         exportable: Boolean (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_size: Integer (Optional)
     *         reuse_key: Boolean (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     }
     *     secret_props (Optional): {
     *         contentType: String (Optional)
     *     }
     *     x509_props (Optional): {
     *         subject: String (Optional)
     *         ekus (Optional): [
     *             String (Optional)
     *         ]
     *         sans (Optional): {
     *             emails (Optional): [
     *                 String (Optional)
     *             ]
     *             dns_names (Optional): [
     *                 String (Optional)
     *             ]
     *             upns (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *         key_usage (Optional): [
     *             String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *         ]
     *         validity_months: Integer (Optional)
     *     }
     *     lifetime_actions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 lifetime_percentage: Integer (Optional)
     *                 days_before_expiry: Integer (Optional)
     *             }
     *             action (Optional): {
     *                 action_type: String(EmailContacts/AutoRenew) (Optional)
     *             }
     *         }
     *     ]
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     key_props (Optional): {
     *         exportable: Boolean (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_size: Integer (Optional)
     *         reuse_key: Boolean (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     }
     *     secret_props (Optional): {
     *         contentType: String (Optional)
     *     }
     *     x509_props (Optional): {
     *         subject: String (Optional)
     *         ekus (Optional): [
     *             String (Optional)
     *         ]
     *         sans (Optional): {
     *             emails (Optional): [
     *                 String (Optional)
     *             ]
     *             dns_names (Optional): [
     *                 String (Optional)
     *             ]
     *             upns (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *         key_usage (Optional): [
     *             String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *         ]
     *         validity_months: Integer (Optional)
     *     }
     *     lifetime_actions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 lifetime_percentage: Integer (Optional)
     *                 days_before_expiry: Integer (Optional)
     *             }
     *             action (Optional): {
     *                 action_type: String(EmailContacts/AutoRenew) (Optional)
     *             }
     *         }
     *     ]
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a certificate along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificatePolicyWithResponseAsync(String certificateName,
        BinaryData certificatePolicy, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.updateCertificatePolicy(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                certificateName, contentType, accept, certificatePolicy, requestOptions, context));
    }

    /**
     * Updates the policy for a certificate.
     * 
     * Set specified members in the certificate policy. Leave others as null. This operation requires the
     * certificates/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     key_props (Optional): {
     *         exportable: Boolean (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_size: Integer (Optional)
     *         reuse_key: Boolean (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     }
     *     secret_props (Optional): {
     *         contentType: String (Optional)
     *     }
     *     x509_props (Optional): {
     *         subject: String (Optional)
     *         ekus (Optional): [
     *             String (Optional)
     *         ]
     *         sans (Optional): {
     *             emails (Optional): [
     *                 String (Optional)
     *             ]
     *             dns_names (Optional): [
     *                 String (Optional)
     *             ]
     *             upns (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *         key_usage (Optional): [
     *             String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *         ]
     *         validity_months: Integer (Optional)
     *     }
     *     lifetime_actions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 lifetime_percentage: Integer (Optional)
     *                 days_before_expiry: Integer (Optional)
     *             }
     *             action (Optional): {
     *                 action_type: String(EmailContacts/AutoRenew) (Optional)
     *             }
     *         }
     *     ]
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     key_props (Optional): {
     *         exportable: Boolean (Optional)
     *         kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *         key_size: Integer (Optional)
     *         reuse_key: Boolean (Optional)
     *         crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *     }
     *     secret_props (Optional): {
     *         contentType: String (Optional)
     *     }
     *     x509_props (Optional): {
     *         subject: String (Optional)
     *         ekus (Optional): [
     *             String (Optional)
     *         ]
     *         sans (Optional): {
     *             emails (Optional): [
     *                 String (Optional)
     *             ]
     *             dns_names (Optional): [
     *                 String (Optional)
     *             ]
     *             upns (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *         key_usage (Optional): [
     *             String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *         ]
     *         validity_months: Integer (Optional)
     *     }
     *     lifetime_actions (Optional): [
     *          (Optional){
     *             trigger (Optional): {
     *                 lifetime_percentage: Integer (Optional)
     *                 days_before_expiry: Integer (Optional)
     *             }
     *             action (Optional): {
     *                 action_type: String(EmailContacts/AutoRenew) (Optional)
     *             }
     *         }
     *     ]
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return management policy for a certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateCertificatePolicyWithResponse(String certificateName,
        BinaryData certificatePolicy, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateCertificatePolicySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, contentType, accept, certificatePolicy, requestOptions, Context.NONE);
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     * 
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated
     * are the certificate's attributes. This operation requires the certificates/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param parameters The parameters for certificate update.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificateWithResponseAsync(String certificateName,
        String certificateVersion, BinaryData parameters, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.updateCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                certificateName, certificateVersion, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Updates the specified attributes associated with the given certificate.
     * 
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated
     * are the certificate's attributes. This operation requires the certificates/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param parameters The parameters for certificate update.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateCertificateWithResponse(String certificateName, String certificateVersion,
        BinaryData parameters, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, certificateVersion, contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Gets information about a certificate.
     * 
     * Gets information about a specific certificate. This operation requires the certificates/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     * latest version of the certificate is returned.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about a certificate.
     * 
     * Gets information about a specific certificate along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateWithResponseAsync(String certificateName, String certificateVersion,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                certificateName, certificateVersion, accept, requestOptions, context));
    }

    /**
     * Gets information about a certificate.
     * 
     * Gets information about a specific certificate. This operation requires the certificates/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate. This URI fragment is optional. If not specified, the
     * latest version of the certificate is returned.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about a certificate.
     * 
     * Gets information about a specific certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCertificateWithResponse(String certificateName, String certificateVersion,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, certificateVersion, accept, requestOptions, Context.NONE);
    }

    /**
     * Updates a certificate operation.
     * 
     * Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     cancellation_requested: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param certificateOperation The certificate operation response.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificateOperationWithResponseAsync(String certificateName,
        BinaryData certificateOperation, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.updateCertificateOperation(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                certificateName, contentType, accept, certificateOperation, requestOptions, context));
    }

    /**
     * Updates a certificate operation.
     * 
     * Updates a certificate creation operation that is already in progress. This operation requires the
     * certificates/update permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     cancellation_requested: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param certificateOperation The certificate operation response.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateCertificateOperationWithResponse(String certificateName,
        BinaryData certificateOperation, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateCertificateOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, contentType, accept, certificateOperation, requestOptions, Context.NONE);
    }

    /**
     * Gets the creation operation of a certificate.
     * 
     * Gets the creation operation associated with a specified certificate. This operation requires the certificates/get
     * permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the creation operation of a certificate.
     * 
     * Gets the creation operation associated with a specified certificate along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateOperationWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getCertificateOperation(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Gets the creation operation of a certificate.
     * 
     * Gets the creation operation associated with a specified certificate. This operation requires the certificates/get
     * permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the creation operation of a certificate.
     * 
     * Gets the creation operation associated with a specified certificate along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCertificateOperationWithResponse(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getCertificateOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * Deletes the creation operation for a specific certificate.
     * 
     * Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateOperationWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteCertificateOperation(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Deletes the creation operation for a specific certificate.
     * 
     * Deletes the creation operation for a specified certificate that is in the process of being created. The
     * certificate is no longer created. This operation requires the certificates/update permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     issuer (Optional): {
     *         name: String (Optional)
     *         cty: String (Optional)
     *         cert_transparency: Boolean (Optional)
     *     }
     *     csr: byte[] (Optional)
     *     cancellation_requested: Boolean (Optional)
     *     status: String (Optional)
     *     status_details: String (Optional)
     *     error (Optional): {
     *         code: String (Optional)
     *         message: String (Optional)
     *         innererror (Optional): (recursive schema, see innererror above)
     *     }
     *     target: String (Optional)
     *     preserveCertOrder: Boolean (Optional)
     *     request_id: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate operation is returned in case of asynchronous requests along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateOperationWithResponse(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteCertificateOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * 
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     x5c (Required): [
     *         byte[] (Required)
     *     ]
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param parameters The parameters to merge certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> mergeCertificateWithResponseAsync(String certificateName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.mergeCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
                certificateName, contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * 
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair
     * currently available in the service. This operation requires the certificates/create permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     x5c (Required): [
     *         byte[] (Required)
     *     ]
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param parameters The parameters to merge certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> mergeCertificateWithResponse(String certificateName, BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.mergeCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Backs up the specified certificate.
     * 
     * Requests that a backup of the specified certificate be downloaded to the client. All versions of the certificate
     * will be downloaded. This operation requires the certificates/backup permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the backup certificate result, containing the backup blob along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> backupCertificateWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.backupCertificate(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Backs up the specified certificate.
     * 
     * Requests that a backup of the specified certificate be downloaded to the client. All versions of the certificate
     * will be downloaded. This operation requires the certificates/backup permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the backup certificate result, containing the backup blob along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> backupCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.backupCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * Restores a backed up certificate to a vault.
     * 
     * Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param parameters The parameters to restore the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> restoreCertificateWithResponseAsync(BinaryData parameters,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.restoreCertificate(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), contentType, accept, parameters, requestOptions, context));
    }

    /**
     * Restores a backed up certificate to a vault.
     * 
     * Restores a backed up certificate, and all its versions, to a vault. This operation requires the
     * certificates/restore permission.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     value: Base64Url (Required)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param parameters The parameters to restore the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> restoreCertificateWithResponse(BinaryData parameters, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.restoreCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            contentType, accept, parameters, requestOptions, Context.NONE);
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * 
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state
     * and ready for recovery or purging. This operation includes deletion-specific information. This operation requires
     * the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getDeletedCertificatesSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeletedCertificates(this.getVaultBaseUrl(),
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * 
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state
     * and ready for recovery or purging. This operation includes deletion-specific information. This operation requires
     * the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of certificates that have been deleted in this vault as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getDeletedCertificatesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> getDeletedCertificatesSinglePageAsync(requestOptions),
            nextLink -> getDeletedCertificatesNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * 
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state
     * and ready for recovery or purging. This operation includes deletion-specific information. This operation requires
     * the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getDeletedCertificatesSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getDeletedCertificatesSync(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * 
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state
     * and ready for recovery or purging. This operation includes deletion-specific information. This operation requires
     * the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>maxresults</td><td>Integer</td><td>No</td><td>Maximum number of results to return in a page. If not
     * specified the service will return up to 25 results.</td></tr>
     * <tr><td>includePending</td><td>Boolean</td><td>No</td><td>Specifies whether to include certificates which are not
     * completely provisioned.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of certificates that have been deleted in this vault as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getDeletedCertificates(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> getDeletedCertificatesSinglePage(requestOptions),
            nextLink -> getDeletedCertificatesNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Retrieves information about the specified deleted certificate.
     * 
     * The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     * when it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeletedCertificateWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getDeletedCertificate(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Retrieves information about the specified deleted certificate.
     * 
     * The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as
     * retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires
     * the certificates/get permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on
     * when it will be purged along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeletedCertificateWithResponse(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getDeletedCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * Permanently deletes the specified deleted certificate.
     * 
     * The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.purgeDeletedCertificate(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Permanently deletes the specified deleted certificate.
     * 
     * The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without
     * possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This
     * operation requires the certificate/purge permission.
     * 
     * @param certificateName The name of the certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.purgeDeletedCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     * 
     * The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the deleted certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> recoverDeletedCertificateWithResponseAsync(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.recoverDeletedCertificate(this.getVaultBaseUrl(),
            this.getServiceVersion().getVersion(), certificateName, accept, requestOptions, context));
    }

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     * 
     * The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is
     * applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the
     * deleted certificate's attributes). This operation requires the certificates/recover permission.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     kid: String (Optional)
     *     sid: String (Optional)
     *     x5t: Base64Url (Optional)
     *     policy (Optional): {
     *         id: String (Optional)
     *         key_props (Optional): {
     *             exportable: Boolean (Optional)
     *             kty: String(EC/EC-HSM/RSA/RSA-HSM/oct/oct-HSM) (Optional)
     *             key_size: Integer (Optional)
     *             reuse_key: Boolean (Optional)
     *             crv: String(P-256/P-384/P-521/P-256K) (Optional)
     *         }
     *         secret_props (Optional): {
     *             contentType: String (Optional)
     *         }
     *         x509_props (Optional): {
     *             subject: String (Optional)
     *             ekus (Optional): [
     *                 String (Optional)
     *             ]
     *             sans (Optional): {
     *                 emails (Optional): [
     *                     String (Optional)
     *                 ]
     *                 dns_names (Optional): [
     *                     String (Optional)
     *                 ]
     *                 upns (Optional): [
     *                     String (Optional)
     *                 ]
     *             }
     *             key_usage (Optional): [
     *                 String(digitalSignature/nonRepudiation/keyEncipherment/dataEncipherment/keyAgreement/keyCertSign/cRLSign/encipherOnly/decipherOnly) (Optional)
     *             ]
     *             validity_months: Integer (Optional)
     *         }
     *         lifetime_actions (Optional): [
     *              (Optional){
     *                 trigger (Optional): {
     *                     lifetime_percentage: Integer (Optional)
     *                     days_before_expiry: Integer (Optional)
     *                 }
     *                 action (Optional): {
     *                     action_type: String(EmailContacts/AutoRenew) (Optional)
     *                 }
     *             }
     *         ]
     *         issuer (Optional): {
     *             name: String (Optional)
     *             cty: String (Optional)
     *             cert_transparency: Boolean (Optional)
     *         }
     *         attributes (Optional): {
     *             enabled: Boolean (Optional)
     *             nbf: Long (Optional)
     *             exp: Long (Optional)
     *             created: Long (Optional)
     *             updated: Long (Optional)
     *             recoverableDays: Integer (Optional)
     *             recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *         }
     *     }
     *     cer: byte[] (Optional)
     *     contentType: String (Optional)
     *     attributes (Optional): (recursive schema, see attributes above)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     preserveCertOrder: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param certificateName The name of the deleted certificate.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a certificate bundle consists of a certificate (X509) plus its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> recoverDeletedCertificateWithResponse(String certificateName,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.recoverDeletedCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(),
            certificateName, accept, requestOptions, Context.NONE);
    }

    /**
     * List certificates in a specified key vault
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificatesNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.getCertificatesNext(nextLink, this.getVaultBaseUrl(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List certificates in a specified key vault
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificatesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res
            = service.getCertificatesNextSync(nextLink, this.getVaultBaseUrl(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List certificate issuers for a specified key vault.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate issuer list result along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateIssuersNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificateIssuersNext(nextLink, this.getVaultBaseUrl(), accept,
                requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List certificate issuers for a specified key vault.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     provider: String (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate issuer list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateIssuersNextSinglePage(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getCertificateIssuersNextSync(nextLink, this.getVaultBaseUrl(), accept,
            requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List the versions of a certificate.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateVersionsNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getCertificateVersionsNext(nextLink, this.getVaultBaseUrl(), accept,
                requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List the versions of a certificate.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the certificate list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateVersionsNextSinglePage(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getCertificateVersionsNextSync(nextLink, this.getVaultBaseUrl(), accept,
            requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getDeletedCertificatesNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeletedCertificatesNext(nextLink, this.getVaultBaseUrl(), accept,
                requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * 
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Optional)
     *     attributes (Optional): {
     *         enabled: Boolean (Optional)
     *         nbf: Long (Optional)
     *         exp: Long (Optional)
     *         created: Long (Optional)
     *         updated: Long (Optional)
     *         recoverableDays: Integer (Optional)
     *         recoveryLevel: String(Purgeable/Recoverable+Purgeable/Recoverable/Recoverable+ProtectedSubscription/CustomizedRecoverable+Purgeable/CustomizedRecoverable/CustomizedRecoverable+ProtectedSubscription) (Optional)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     x5t: Base64Url (Optional)
     *     recoveryId: String (Optional)
     *     scheduledPurgeDate: Long (Optional)
     *     deletedDate: Long (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of certificates that have been deleted in this vault along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> getDeletedCertificatesNextSinglePage(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.getDeletedCertificatesNextSync(nextLink, this.getVaultBaseUrl(), accept,
            requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
