// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A certificate bundle consists of a certificate (X509) plus its attributes.
 */
@Immutable
public final class CertificateBundle implements JsonSerializable<CertificateBundle> {
    /*
     * The certificate id.
     */
    @Generated
    private String id;

    /*
     * The key id.
     */
    @Generated
    private String kid;

    /*
     * The secret id.
     */
    @Generated
    private String sid;

    /*
     * Thumbprint of the certificate.
     */
    @Generated
    private Base64Url x509Thumbprint;

    /*
     * The management policy.
     */
    @Generated
    private CertificatePolicy policy;

    /*
     * CER contents of x509 certificate.
     */
    @Generated
    private byte[] cer;

    /*
     * The content type of the secret. eg. 'application/x-pem-file' or 'application/x-pkcs12',
     */
    @Generated
    private String contentType;

    /*
     * The certificate attributes.
     */
    @Generated
    private CertificateAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Specifies whether the certificate chain preserves its original order. The default value is false, which sets the
     * leaf certificate at index 0.
     */
    @Generated
    private Boolean preserveCertOrder;

    /**
     * Creates an instance of CertificateBundle class.
     */
    @Generated
    private CertificateBundle() {
    }

    /**
     * Get the id property: The certificate id.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the kid property: The key id.
     * 
     * @return the kid value.
     */
    @Generated
    public String getKid() {
        return this.kid;
    }

    /**
     * Get the sid property: The secret id.
     * 
     * @return the sid value.
     */
    @Generated
    public String getSid() {
        return this.sid;
    }

    /**
     * Get the x509Thumbprint property: Thumbprint of the certificate.
     * 
     * @return the x509Thumbprint value.
     */
    @Generated
    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    /**
     * Get the policy property: The management policy.
     * 
     * @return the policy value.
     */
    @Generated
    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    /**
     * Get the cer property: CER contents of x509 certificate.
     * 
     * @return the cer value.
     */
    @Generated
    public byte[] getCer() {
        return CoreUtils.clone(this.cer);
    }

    /**
     * Get the contentType property: The content type of the secret. eg. 'application/x-pem-file' or
     * 'application/x-pkcs12',.
     * 
     * @return the contentType value.
     */
    @Generated
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Get the attributes property: The certificate attributes.
     * 
     * @return the attributes value.
     */
    @Generated
    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the preserveCertOrder property: Specifies whether the certificate chain preserves its original order. The
     * default value is false, which sets the leaf certificate at index 0.
     * 
     * @return the preserveCertOrder value.
     */
    @Generated
    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", this.cer);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateBundle from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateBundle if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateBundle.
     */
    @Generated
    public static CertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateBundle deserializedCertificateBundle = new CertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCertificateBundle.id = reader.getString();
                } else if ("kid".equals(fieldName)) {
                    deserializedCertificateBundle.kid = reader.getString();
                } else if ("sid".equals(fieldName)) {
                    deserializedCertificateBundle.sid = reader.getString();
                } else if ("x5t".equals(fieldName)) {
                    deserializedCertificateBundle.x509Thumbprint
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("policy".equals(fieldName)) {
                    deserializedCertificateBundle.policy = CertificatePolicy.fromJson(reader);
                } else if ("cer".equals(fieldName)) {
                    deserializedCertificateBundle.cer = reader.getBinary();
                } else if ("contentType".equals(fieldName)) {
                    deserializedCertificateBundle.contentType = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedCertificateBundle.attributes = CertificateAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCertificateBundle.tags = tags;
                } else if ("preserveCertOrder".equals(fieldName)) {
                    deserializedCertificateBundle.preserveCertOrder = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateBundle;
        });
    }
}
