// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The certificate create parameters.
 */
@Fluent
public final class CertificateCreateParameters implements JsonSerializable<CertificateCreateParameters> {
    /*
     * The management policy for the certificate.
     */
    @Generated
    private CertificatePolicy certificatePolicy;

    /*
     * The attributes of the certificate (optional).
     */
    @Generated
    private CertificateAttributes certificateAttributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Specifies whether the certificate chain preserves its original order. The default value is false, which sets the
     * leaf certificate at index 0.
     */
    @Generated
    private Boolean preserveCertOrder;

    /**
     * Creates an instance of CertificateCreateParameters class.
     */
    @Generated
    public CertificateCreateParameters() {
    }

    /**
     * Get the certificatePolicy property: The management policy for the certificate.
     * 
     * @return the certificatePolicy value.
     */
    @Generated
    public CertificatePolicy getCertificatePolicy() {
        return this.certificatePolicy;
    }

    /**
     * Set the certificatePolicy property: The management policy for the certificate.
     * 
     * @param certificatePolicy the certificatePolicy value to set.
     * @return the CertificateCreateParameters object itself.
     */
    @Generated
    public CertificateCreateParameters setCertificatePolicy(CertificatePolicy certificatePolicy) {
        this.certificatePolicy = certificatePolicy;
        return this;
    }

    /**
     * Get the certificateAttributes property: The attributes of the certificate (optional).
     * 
     * @return the certificateAttributes value.
     */
    @Generated
    public CertificateAttributes getCertificateAttributes() {
        return this.certificateAttributes;
    }

    /**
     * Set the certificateAttributes property: The attributes of the certificate (optional).
     * 
     * @param certificateAttributes the certificateAttributes value to set.
     * @return the CertificateCreateParameters object itself.
     */
    @Generated
    public CertificateCreateParameters setCertificateAttributes(CertificateAttributes certificateAttributes) {
        this.certificateAttributes = certificateAttributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the CertificateCreateParameters object itself.
     */
    @Generated
    public CertificateCreateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the preserveCertOrder property: Specifies whether the certificate chain preserves its original order. The
     * default value is false, which sets the leaf certificate at index 0.
     * 
     * @return the preserveCertOrder value.
     */
    @Generated
    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    /**
     * Set the preserveCertOrder property: Specifies whether the certificate chain preserves its original order. The
     * default value is false, which sets the leaf certificate at index 0.
     * 
     * @param preserveCertOrder the preserveCertOrder value to set.
     * @return the CertificateCreateParameters object itself.
     */
    @Generated
    public CertificateCreateParameters setPreserveCertOrder(Boolean preserveCertOrder) {
        this.preserveCertOrder = preserveCertOrder;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", this.certificatePolicy);
        jsonWriter.writeJsonField("attributes", this.certificateAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateCreateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateCreateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateCreateParameters.
     */
    @Generated
    public static CertificateCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateCreateParameters deserializedCertificateCreateParameters = new CertificateCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("policy".equals(fieldName)) {
                    deserializedCertificateCreateParameters.certificatePolicy = CertificatePolicy.fromJson(reader);
                } else if ("attributes".equals(fieldName)) {
                    deserializedCertificateCreateParameters.certificateAttributes
                        = CertificateAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCertificateCreateParameters.tags = tags;
                } else if ("preserveCertOrder".equals(fieldName)) {
                    deserializedCertificateCreateParameters.preserveCertOrder
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateCreateParameters;
        });
    }
}
