// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The certificate merge parameters.
 */
@Fluent
public final class CertificateMergeParameters implements JsonSerializable<CertificateMergeParameters> {
    /*
     * The certificate or the certificate chain to merge.
     */
    @Generated
    private final List<byte[]> x509Certificates;

    /*
     * The attributes of the certificate (optional).
     */
    @Generated
    private CertificateAttributes certificateAttributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /**
     * Creates an instance of CertificateMergeParameters class.
     * 
     * @param x509Certificates the x509Certificates value to set.
     */
    @Generated
    public CertificateMergeParameters(List<byte[]> x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    /**
     * Get the x509Certificates property: The certificate or the certificate chain to merge.
     * 
     * @return the x509Certificates value.
     */
    @Generated
    public List<byte[]> getX509Certificates() {
        return this.x509Certificates;
    }

    /**
     * Get the certificateAttributes property: The attributes of the certificate (optional).
     * 
     * @return the certificateAttributes value.
     */
    @Generated
    public CertificateAttributes getCertificateAttributes() {
        return this.certificateAttributes;
    }

    /**
     * Set the certificateAttributes property: The attributes of the certificate (optional).
     * 
     * @param certificateAttributes the certificateAttributes value to set.
     * @return the CertificateMergeParameters object itself.
     */
    @Generated
    public CertificateMergeParameters setCertificateAttributes(CertificateAttributes certificateAttributes) {
        this.certificateAttributes = certificateAttributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the CertificateMergeParameters object itself.
     */
    @Generated
    public CertificateMergeParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("x5c", this.x509Certificates, (writer, element) -> writer.writeBinary(element));
        jsonWriter.writeJsonField("attributes", this.certificateAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateMergeParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateMergeParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateMergeParameters.
     */
    @Generated
    public static CertificateMergeParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<byte[]> x509Certificates = null;
            CertificateAttributes certificateAttributes = null;
            Map<String, String> tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("x5c".equals(fieldName)) {
                    x509Certificates = reader.readArray(reader1 -> reader1.getBinary());
                } else if ("attributes".equals(fieldName)) {
                    certificateAttributes = CertificateAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            CertificateMergeParameters deserializedCertificateMergeParameters
                = new CertificateMergeParameters(x509Certificates);
            deserializedCertificateMergeParameters.certificateAttributes = certificateAttributes;
            deserializedCertificateMergeParameters.tags = tags;

            return deserializedCertificateMergeParameters;
        });
    }
}
