// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The certificate operation update parameters.
 */
@Immutable
public final class CertificateOperationUpdateParameter
    implements JsonSerializable<CertificateOperationUpdateParameter> {
    /*
     * Indicates if cancellation was requested on the certificate operation.
     */
    @Generated
    private final boolean cancellationRequested;

    /**
     * Creates an instance of CertificateOperationUpdateParameter class.
     * 
     * @param cancellationRequested the cancellationRequested value to set.
     */
    @Generated
    public CertificateOperationUpdateParameter(boolean cancellationRequested) {
        this.cancellationRequested = cancellationRequested;
    }

    /**
     * Get the cancellationRequested property: Indicates if cancellation was requested on the certificate operation.
     * 
     * @return the cancellationRequested value.
     */
    @Generated
    public boolean isCancellationRequested() {
        return this.cancellationRequested;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("cancellation_requested", this.cancellationRequested);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateOperationUpdateParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateOperationUpdateParameter if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateOperationUpdateParameter.
     */
    @Generated
    public static CertificateOperationUpdateParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean cancellationRequested = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cancellation_requested".equals(fieldName)) {
                    cancellationRequested = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }
            return new CertificateOperationUpdateParameter(cancellationRequested);
        });
    }
}
