// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Management policy for a certificate.
 */
@Fluent
public final class CertificatePolicy implements JsonSerializable<CertificatePolicy> {
    /*
     * The certificate id.
     */
    @Generated
    private String id;

    /*
     * Properties of the key backing a certificate.
     */
    @Generated
    private KeyProperties keyProperties;

    /*
     * Properties of the secret backing a certificate.
     */
    @Generated
    private SecretProperties secretProperties;

    /*
     * Properties of the X509 component of a certificate.
     */
    @Generated
    private X509CertificateProperties x509CertificateProperties;

    /*
     * Actions that will be performed by Key Vault over the lifetime of a certificate.
     */
    @Generated
    private List<LifetimeAction> lifetimeActions;

    /*
     * Parameters for the issuer of the X509 component of a certificate.
     */
    @Generated
    private IssuerParameters issuerParameters;

    /*
     * The certificate attributes.
     */
    @Generated
    private CertificateAttributes attributes;

    /**
     * Creates an instance of CertificatePolicy class.
     */
    @Generated
    public CertificatePolicy() {
    }

    /**
     * Get the id property: The certificate id.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the keyProperties property: Properties of the key backing a certificate.
     * 
     * @return the keyProperties value.
     */
    @Generated
    public KeyProperties getKeyProperties() {
        return this.keyProperties;
    }

    /**
     * Set the keyProperties property: Properties of the key backing a certificate.
     * 
     * @param keyProperties the keyProperties value to set.
     * @return the CertificatePolicy object itself.
     */
    @Generated
    public CertificatePolicy setKeyProperties(KeyProperties keyProperties) {
        this.keyProperties = keyProperties;
        return this;
    }

    /**
     * Get the secretProperties property: Properties of the secret backing a certificate.
     * 
     * @return the secretProperties value.
     */
    @Generated
    public SecretProperties getSecretProperties() {
        return this.secretProperties;
    }

    /**
     * Set the secretProperties property: Properties of the secret backing a certificate.
     * 
     * @param secretProperties the secretProperties value to set.
     * @return the CertificatePolicy object itself.
     */
    @Generated
    public CertificatePolicy setSecretProperties(SecretProperties secretProperties) {
        this.secretProperties = secretProperties;
        return this;
    }

    /**
     * Get the x509CertificateProperties property: Properties of the X509 component of a certificate.
     * 
     * @return the x509CertificateProperties value.
     */
    @Generated
    public X509CertificateProperties getX509CertificateProperties() {
        return this.x509CertificateProperties;
    }

    /**
     * Set the x509CertificateProperties property: Properties of the X509 component of a certificate.
     * 
     * @param x509CertificateProperties the x509CertificateProperties value to set.
     * @return the CertificatePolicy object itself.
     */
    @Generated
    public CertificatePolicy setX509CertificateProperties(X509CertificateProperties x509CertificateProperties) {
        this.x509CertificateProperties = x509CertificateProperties;
        return this;
    }

    /**
     * Get the lifetimeActions property: Actions that will be performed by Key Vault over the lifetime of a certificate.
     * 
     * @return the lifetimeActions value.
     */
    @Generated
    public List<LifetimeAction> getLifetimeActions() {
        return this.lifetimeActions;
    }

    /**
     * Set the lifetimeActions property: Actions that will be performed by Key Vault over the lifetime of a certificate.
     * 
     * @param lifetimeActions the lifetimeActions value to set.
     * @return the CertificatePolicy object itself.
     */
    @Generated
    public CertificatePolicy setLifetimeActions(List<LifetimeAction> lifetimeActions) {
        this.lifetimeActions = lifetimeActions;
        return this;
    }

    /**
     * Get the issuerParameters property: Parameters for the issuer of the X509 component of a certificate.
     * 
     * @return the issuerParameters value.
     */
    @Generated
    public IssuerParameters getIssuerParameters() {
        return this.issuerParameters;
    }

    /**
     * Set the issuerParameters property: Parameters for the issuer of the X509 component of a certificate.
     * 
     * @param issuerParameters the issuerParameters value to set.
     * @return the CertificatePolicy object itself.
     */
    @Generated
    public CertificatePolicy setIssuerParameters(IssuerParameters issuerParameters) {
        this.issuerParameters = issuerParameters;
        return this;
    }

    /**
     * Get the attributes property: The certificate attributes.
     * 
     * @return the attributes value.
     */
    @Generated
    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The certificate attributes.
     * 
     * @param attributes the attributes value to set.
     * @return the CertificatePolicy object itself.
     */
    @Generated
    public CertificatePolicy setAttributes(CertificateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key_props", this.keyProperties);
        jsonWriter.writeJsonField("secret_props", this.secretProperties);
        jsonWriter.writeJsonField("x509_props", this.x509CertificateProperties);
        jsonWriter.writeArrayField("lifetime_actions", this.lifetimeActions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("issuer", this.issuerParameters);
        jsonWriter.writeJsonField("attributes", this.attributes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificatePolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificatePolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificatePolicy.
     */
    @Generated
    public static CertificatePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificatePolicy deserializedCertificatePolicy = new CertificatePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCertificatePolicy.id = reader.getString();
                } else if ("key_props".equals(fieldName)) {
                    deserializedCertificatePolicy.keyProperties = KeyProperties.fromJson(reader);
                } else if ("secret_props".equals(fieldName)) {
                    deserializedCertificatePolicy.secretProperties = SecretProperties.fromJson(reader);
                } else if ("x509_props".equals(fieldName)) {
                    deserializedCertificatePolicy.x509CertificateProperties
                        = X509CertificateProperties.fromJson(reader);
                } else if ("lifetime_actions".equals(fieldName)) {
                    List<LifetimeAction> lifetimeActions
                        = reader.readArray(reader1 -> LifetimeAction.fromJson(reader1));
                    deserializedCertificatePolicy.lifetimeActions = lifetimeActions;
                } else if ("issuer".equals(fieldName)) {
                    deserializedCertificatePolicy.issuerParameters = IssuerParameters.fromJson(reader);
                } else if ("attributes".equals(fieldName)) {
                    deserializedCertificatePolicy.attributes = CertificateAttributes.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificatePolicy;
        });
    }
}
