// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/**
 * The certificate restore parameters.
 */
@Immutable
public final class CertificateRestoreParameters implements JsonSerializable<CertificateRestoreParameters> {
    /*
     * The backup blob associated with a certificate bundle.
     */
    @Generated
    private final Base64Url certificateBundleBackup;

    /**
     * Creates an instance of CertificateRestoreParameters class.
     * 
     * @param certificateBundleBackup the certificateBundleBackup value to set.
     */
    @Generated
    public CertificateRestoreParameters(byte[] certificateBundleBackup) {
        if (certificateBundleBackup == null) {
            this.certificateBundleBackup = null;
        } else {
            this.certificateBundleBackup = Base64Url.encode(certificateBundleBackup);
        }
    }

    /**
     * Get the certificateBundleBackup property: The backup blob associated with a certificate bundle.
     * 
     * @return the certificateBundleBackup value.
     */
    @Generated
    public byte[] getCertificateBundleBackup() {
        if (this.certificateBundleBackup == null) {
            return null;
        }
        return this.certificateBundleBackup.decodedBytes();
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.certificateBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateRestoreParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateRestoreParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateRestoreParameters.
     */
    @Generated
    public static CertificateRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            byte[] certificateBundleBackup = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    Base64Url certificateBundleBackupHolder
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (certificateBundleBackupHolder != null) {
                        certificateBundleBackup = certificateBundleBackupHolder.decodedBytes();
                    }
                } else {
                    reader.skipChildren();
                }
            }
            return new CertificateRestoreParameters(certificateBundleBackup);
        });
    }
}
