// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/**
 * A Deleted Certificate consisting of its previous id, attributes and its tags, as well as information on when it will
 * be purged.
 */
@Immutable
public final class DeletedCertificateBundle implements JsonSerializable<DeletedCertificateBundle> {
    /*
     * The certificate id.
     */
    @Generated
    private String id;

    /*
     * The key id.
     */
    @Generated
    private String kid;

    /*
     * The secret id.
     */
    @Generated
    private String sid;

    /*
     * Thumbprint of the certificate.
     */
    @Generated
    private Base64Url x509Thumbprint;

    /*
     * The management policy.
     */
    @Generated
    private CertificatePolicy policy;

    /*
     * CER contents of x509 certificate.
     */
    @Generated
    private byte[] cer;

    /*
     * The content type of the secret. eg. 'application/x-pem-file' or 'application/x-pkcs12',
     */
    @Generated
    private String contentType;

    /*
     * The certificate attributes.
     */
    @Generated
    private CertificateAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Specifies whether the certificate chain preserves its original order. The default value is false, which sets the
     * leaf certificate at index 0.
     */
    @Generated
    private Boolean preserveCertOrder;

    /*
     * The url of the recovery object, used to identify and recover the deleted certificate.
     */
    @Generated
    private String recoveryId;

    /*
     * The time when the certificate is scheduled to be purged, in UTC
     */
    @Generated
    private Long scheduledPurgeDate;

    /*
     * The time when the certificate was deleted, in UTC
     */
    @Generated
    private Long deletedDate;

    /**
     * Creates an instance of DeletedCertificateBundle class.
     */
    @Generated
    private DeletedCertificateBundle() {
    }

    /**
     * Get the id property: The certificate id.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the kid property: The key id.
     * 
     * @return the kid value.
     */
    @Generated
    public String getKid() {
        return this.kid;
    }

    /**
     * Get the sid property: The secret id.
     * 
     * @return the sid value.
     */
    @Generated
    public String getSid() {
        return this.sid;
    }

    /**
     * Get the x509Thumbprint property: Thumbprint of the certificate.
     * 
     * @return the x509Thumbprint value.
     */
    @Generated
    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    /**
     * Get the policy property: The management policy.
     * 
     * @return the policy value.
     */
    @Generated
    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    /**
     * Get the cer property: CER contents of x509 certificate.
     * 
     * @return the cer value.
     */
    @Generated
    public byte[] getCer() {
        return CoreUtils.clone(this.cer);
    }

    /**
     * Get the contentType property: The content type of the secret. eg. 'application/x-pem-file' or
     * 'application/x-pkcs12',.
     * 
     * @return the contentType value.
     */
    @Generated
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Get the attributes property: The certificate attributes.
     * 
     * @return the attributes value.
     */
    @Generated
    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the preserveCertOrder property: Specifies whether the certificate chain preserves its original order. The
     * default value is false, which sets the leaf certificate at index 0.
     * 
     * @return the preserveCertOrder value.
     */
    @Generated
    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted
     * certificate.
     * 
     * @return the recoveryId value.
     */
    @Generated
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the certificate is scheduled to be purged, in UTC.
     * 
     * @return the scheduledPurgeDate value.
     */
    @Generated
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the certificate was deleted, in UTC.
     * 
     * @return the deletedDate value.
     */
    @Generated
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", this.cer);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedCertificateBundle from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedCertificateBundle if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedCertificateBundle.
     */
    @Generated
    public static DeletedCertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedCertificateBundle deserializedDeletedCertificateBundle = new DeletedCertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.id = reader.getString();
                } else if ("kid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.kid = reader.getString();
                } else if ("sid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.sid = reader.getString();
                } else if ("x5t".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.x509Thumbprint
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("policy".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.policy = CertificatePolicy.fromJson(reader);
                } else if ("cer".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.cer = reader.getBinary();
                } else if ("contentType".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.contentType = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.attributes = CertificateAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedCertificateBundle.tags = tags;
                } else if ("preserveCertOrder".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.preserveCertOrder = reader.getNullable(JsonReader::getBoolean);
                } else if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.recoveryId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                } else if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.deletedDate = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedCertificateBundle;
        });
    }
}
