// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

/**
 * The deleted certificate item containing metadata about the deleted certificate.
 */
@Immutable
public final class DeletedCertificateItem implements JsonSerializable<DeletedCertificateItem> {
    /*
     * Certificate identifier.
     */
    @Generated
    private String id;

    /*
     * The certificate management attributes.
     */
    @Generated
    private CertificateAttributes attributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Thumbprint of the certificate.
     */
    @Generated
    private Base64Url x509Thumbprint;

    /*
     * The url of the recovery object, used to identify and recover the deleted certificate.
     */
    @Generated
    private String recoveryId;

    /*
     * The time when the certificate is scheduled to be purged, in UTC
     */
    @Generated
    private Long scheduledPurgeDate;

    /*
     * The time when the certificate was deleted, in UTC
     */
    @Generated
    private Long deletedDate;

    /**
     * Creates an instance of DeletedCertificateItem class.
     */
    @Generated
    private DeletedCertificateItem() {
    }

    /**
     * Get the id property: Certificate identifier.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the attributes property: The certificate management attributes.
     * 
     * @return the attributes value.
     */
    @Generated
    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the x509Thumbprint property: Thumbprint of the certificate.
     * 
     * @return the x509Thumbprint value.
     */
    @Generated
    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted
     * certificate.
     * 
     * @return the recoveryId value.
     */
    @Generated
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the certificate is scheduled to be purged, in UTC.
     * 
     * @return the scheduledPurgeDate value.
     */
    @Generated
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the certificate was deleted, in UTC.
     * 
     * @return the deletedDate value.
     */
    @Generated
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("x5t", Objects.toString(this.x509Thumbprint, null));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedCertificateItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedCertificateItem if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedCertificateItem.
     */
    @Generated
    public static DeletedCertificateItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedCertificateItem deserializedDeletedCertificateItem = new DeletedCertificateItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateItem.id = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateItem.attributes = CertificateAttributes.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedCertificateItem.tags = tags;
                } else if ("x5t".equals(fieldName)) {
                    deserializedDeletedCertificateItem.x509Thumbprint
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateItem.recoveryId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                } else if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.deletedDate = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedCertificateItem;
        });
    }
}
