// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.models.CertificateKeyCurveName;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import java.io.IOException;

/**
 * Properties of the key pair backing a certificate.
 */
@Fluent
public final class KeyProperties implements JsonSerializable<KeyProperties> {
    /*
     * Indicates if the private key can be exported. Release policy must be provided when creating the first version of
     * an exportable key.
     */
    @Generated
    private Boolean exportable;

    /*
     * The type of key pair to be used for the certificate.
     */
    @Generated
    private CertificateKeyType keyType;

    /*
     * The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     */
    @Generated
    private Integer keySize;

    /*
     * Indicates if the same key pair will be used on certificate renewal.
     */
    @Generated
    private Boolean reuseKey;

    /*
     * Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     */
    @Generated
    private CertificateKeyCurveName curve;

    /**
     * Creates an instance of KeyProperties class.
     */
    @Generated
    public KeyProperties() {
    }

    /**
     * Get the exportable property: Indicates if the private key can be exported. Release policy must be provided when
     * creating the first version of an exportable key.
     * 
     * @return the exportable value.
     */
    @Generated
    public Boolean isExportable() {
        return this.exportable;
    }

    /**
     * Set the exportable property: Indicates if the private key can be exported. Release policy must be provided when
     * creating the first version of an exportable key.
     * 
     * @param exportable the exportable value to set.
     * @return the KeyProperties object itself.
     */
    @Generated
    public KeyProperties setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    /**
     * Get the keyType property: The type of key pair to be used for the certificate.
     * 
     * @return the keyType value.
     */
    @Generated
    public CertificateKeyType getKeyType() {
        return this.keyType;
    }

    /**
     * Set the keyType property: The type of key pair to be used for the certificate.
     * 
     * @param keyType the keyType value to set.
     * @return the KeyProperties object itself.
     */
    @Generated
    public KeyProperties setKeyType(CertificateKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    /**
     * Get the keySize property: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * 
     * @return the keySize value.
     */
    @Generated
    public Integer getKeySize() {
        return this.keySize;
    }

    /**
     * Set the keySize property: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * 
     * @param keySize the keySize value to set.
     * @return the KeyProperties object itself.
     */
    @Generated
    public KeyProperties setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    /**
     * Get the reuseKey property: Indicates if the same key pair will be used on certificate renewal.
     * 
     * @return the reuseKey value.
     */
    @Generated
    public Boolean isReuseKey() {
        return this.reuseKey;
    }

    /**
     * Set the reuseKey property: Indicates if the same key pair will be used on certificate renewal.
     * 
     * @param reuseKey the reuseKey value to set.
     * @return the KeyProperties object itself.
     */
    @Generated
    public KeyProperties setReuseKey(Boolean reuseKey) {
        this.reuseKey = reuseKey;
        return this;
    }

    /**
     * Get the curve property: Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     * 
     * @return the curve value.
     */
    @Generated
    public CertificateKeyCurveName getCurve() {
        return this.curve;
    }

    /**
     * Set the curve property: Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     * 
     * @param curve the curve value to set.
     * @return the KeyProperties object itself.
     */
    @Generated
    public KeyProperties setCurve(CertificateKeyCurveName curve) {
        this.curve = curve;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("exportable", this.exportable);
        jsonWriter.writeStringField("kty", this.keyType == null ? null : this.keyType.toString());
        jsonWriter.writeNumberField("key_size", this.keySize);
        jsonWriter.writeBooleanField("reuse_key", this.reuseKey);
        jsonWriter.writeStringField("crv", this.curve == null ? null : this.curve.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyProperties.
     */
    @Generated
    public static KeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyProperties deserializedKeyProperties = new KeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("exportable".equals(fieldName)) {
                    deserializedKeyProperties.exportable = reader.getNullable(JsonReader::getBoolean);
                } else if ("kty".equals(fieldName)) {
                    deserializedKeyProperties.keyType = CertificateKeyType.fromString(reader.getString());
                } else if ("key_size".equals(fieldName)) {
                    deserializedKeyProperties.keySize = reader.getNullable(JsonReader::getInt);
                } else if ("reuse_key".equals(fieldName)) {
                    deserializedKeyProperties.reuseKey = reader.getNullable(JsonReader::getBoolean);
                } else if ("crv".equals(fieldName)) {
                    deserializedKeyProperties.curve = CertificateKeyCurveName.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyProperties;
        });
    }
}
