// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.security.keyvault.certificates.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The contact information for the vault certificates.
 */
@Fluent
public final class CertificateContact implements JsonSerializable<CertificateContact> {
    /*
     * Email address.
     */
    @Generated
    private String email;

    /*
     * Name.
     */
    @Generated
    private String name;

    /*
     * Phone number.
     */
    @Generated
    private String phone;

    /**
     * Creates an instance of CertificateContact class.
     */
    @Generated
    public CertificateContact() {
    }

    /**
     * Get the email property: Email address.
     * 
     * @return the email value.
     */
    @Generated
    public String getEmail() {
        return this.email;
    }

    /**
     * Set the email property: Email address.
     * 
     * @param email the email value to set.
     * @return the CertificateContact object itself.
     */
    @Generated
    public CertificateContact setEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the name property: Name.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Name.
     * 
     * @param name the name value to set.
     * @return the CertificateContact object itself.
     */
    @Generated
    public CertificateContact setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the phone property: Phone number.
     * 
     * @return the phone value.
     */
    @Generated
    public String getPhone() {
        return this.phone;
    }

    /**
     * Set the phone property: Phone number.
     * 
     * @param phone the phone value to set.
     * @return the CertificateContact object itself.
     */
    @Generated
    public CertificateContact setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("phone", this.phone);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateContact from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateContact if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateContact.
     */
    @Generated
    public static CertificateContact fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateContact deserializedCertificateContact = new CertificateContact();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("email".equals(fieldName)) {
                    deserializedCertificateContact.email = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCertificateContact.name = reader.getString();
                } else if ("phone".equals(fieldName)) {
                    deserializedCertificateContact.phone = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateContact;
        });
    }
}
