// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.security.keyvault.certificates.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of key pair to be used for the certificate.
 */
public final class CertificateKeyType extends ExpandableStringEnum<CertificateKeyType> {

    /**
     * Elliptic Curve.
     */
    @Generated
    public static final CertificateKeyType EC = fromString("EC");

    /**
     * Elliptic Curve with a private key which is not exportable from the HSM.
     */
    @Generated
    public static final CertificateKeyType EC_HSM = fromString("EC-HSM");

    /**
     * RSA (https://tools.ietf.org/html/rfc3447).
     */
    @Generated
    public static final CertificateKeyType RSA = fromString("RSA");

    /**
     * RSA with a private key which is not exportable from the HSM.
     */
    @Generated
    public static final CertificateKeyType RSA_HSM = fromString("RSA-HSM");

    /**
     * Octet sequence (used to represent symmetric keys).
     */
    @Generated
    private static final CertificateKeyType OCT = fromString("oct");

    /**
     * Octet sequence with a private key which is not exportable from the HSM.
     */
    @Generated
    private static final CertificateKeyType OCT_HSM = fromString("oct-HSM");

    /**
     * Creates a new instance of CertificateKeyType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public CertificateKeyType() {
    }

    /**
     * Creates or finds a CertificateKeyType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CertificateKeyType.
     */
    @Generated
    public static CertificateKeyType fromString(String name) {
        return fromString(name, CertificateKeyType.class);
    }

    /**
     * Gets known CertificateKeyType values.
     *
     * @return known CertificateKeyType values.
     */
    @Generated
    public static Collection<CertificateKeyType> values() {
        return values(CertificateKeyType.class);
    }
}
