// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.security.keyvault.certificates.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Supported usages of a certificate key.
 */
public final class CertificateKeyUsage extends ExpandableStringEnum<CertificateKeyUsage> {

    /**
     * Indicates that the certificate key can be used as a digital signature.
     */
    @Generated
    public static final CertificateKeyUsage DIGITAL_SIGNATURE = fromString("digitalSignature");

    /**
     * Indicates that the certificate key can be used for authentication.
     */
    @Generated
    public static final CertificateKeyUsage NON_REPUDIATION = fromString("nonRepudiation");

    /**
     * Indicates that the certificate key can be used for key encryption.
     */
    @Generated
    public static final CertificateKeyUsage KEY_ENCIPHERMENT = fromString("keyEncipherment");

    /**
     * Indicates that the certificate key can be used for data encryption.
     */
    @Generated
    public static final CertificateKeyUsage DATA_ENCIPHERMENT = fromString("dataEncipherment");

    /**
     * Indicates that the certificate key can be used to determine key agreement, such as a key created using the
     * Diffie-Hellman key agreement algorithm.
     */
    @Generated
    public static final CertificateKeyUsage KEY_AGREEMENT = fromString("keyAgreement");

    /**
     * Indicates that the certificate key can be used to sign certificates.
     */
    @Generated
    public static final CertificateKeyUsage KEY_CERT_SIGN = fromString("keyCertSign");

    /**
     * Indicates that the certificate key can be used to sign a certificate revocation list.
     */
    @Generated
    public static final CertificateKeyUsage CRL_SIGN = fromString("cRLSign");

    /**
     * Indicates that the certificate key can be used for encryption only.
     */
    @Generated
    public static final CertificateKeyUsage ENCIPHER_ONLY = fromString("encipherOnly");

    /**
     * Indicates that the certificate key can be used for decryption only.
     */
    @Generated
    public static final CertificateKeyUsage DECIPHER_ONLY = fromString("decipherOnly");

    /**
     * Creates a new instance of CertificateKeyUsage value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public CertificateKeyUsage() {
    }

    /**
     * Creates or finds a CertificateKeyUsage from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CertificateKeyUsage.
     */
    @Generated
    public static CertificateKeyUsage fromString(String name) {
        return fromString(name, CertificateKeyUsage.class);
    }

    /**
     * Gets known CertificateKeyUsage values.
     *
     * @return known CertificateKeyUsage values.
     */
    @Generated
    public static Collection<CertificateKeyUsage> values() {
        return values(CertificateKeyUsage.class);
    }
}
