/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateServiceVersion;
import com.azure.security.keyvault.certificates.implementation.CertificateClientImpl;
import com.azure.security.keyvault.certificates.implementation.KeyVaultCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={CertificateClient.class, CertificateAsyncClient.class})
public final class CertificateClientBuilder
implements TokenCredentialTrait<CertificateClientBuilder>,
HttpTrait<CertificateClientBuilder>,
ConfigurationTrait<CertificateClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateClientBuilder.class);
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS;
    private final List<HttpPipelinePolicy> perCallPolicies;
    private final List<HttpPipelinePolicy> perRetryPolicies;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private String vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private CertificateServiceVersion version;
    private ClientOptions clientOptions;
    private boolean disableChallengeResourceVerification = false;

    public CertificateClientBuilder() {
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    }

    public CertificateClient buildClient() {
        return new CertificateClient(this.buildImplClient(), this.vaultUrl);
    }

    public CertificateAsyncClient buildAsyncClient() {
        return new CertificateAsyncClient(this.buildImplClient(), this.vaultUrl);
    }

    private CertificateClientImpl buildImplClient() {
        Configuration buildConfiguration = this.configuration != null ? this.configuration : Configuration.getGlobalConfiguration().clone();
        String buildEndpoint = this.getBuildEndpoint(buildConfiguration);
        if (buildEndpoint == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault endpoint url is required."));
        }
        if (this.version == null) {
            this.version = CertificateServiceVersion.getLatest();
        }
        if (this.pipeline != null) {
            return new CertificateClientImpl(this.pipeline, this.vaultUrl, this.version);
        }
        if (this.credential == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault credentials are required."));
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions != null ? this.clientOptions : DEFAULT_CLIENT_OPTIONS;
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)this.httpLogOptions), CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)localClientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        policies.add((Object)new KeyVaultCredentialPolicy(this.credential, this.disableChallengeResourceVerification));
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        TracingOptions tracingOptions = localClientOptions.getTracingOptions();
        Tracer tracer = TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, KEYVAULT_TRACING_NAMESPACE_VALUE, tracingOptions);
        HttpPipeline builtPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer(tracer).clientOptions(localClientOptions).build();
        return new CertificateClientImpl(builtPipeline, this.vaultUrl, this.version);
    }

    public CertificateClientBuilder vaultUrl(String vaultUrl) {
        if (vaultUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'vaultUrl' cannot be null."));
        }
        try {
            URL url = new URL(vaultUrl);
            this.vaultUrl = url.toString();
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault endpoint url is malformed.", e));
        }
        return this;
    }

    public CertificateClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    public CertificateClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public CertificateClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public CertificateClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    public CertificateClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public CertificateClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public CertificateClientBuilder serviceVersion(CertificateServiceVersion version) {
        this.version = version;
        return this;
    }

    public CertificateClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public CertificateClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public CertificateClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public CertificateClientBuilder disableChallengeResourceVerification() {
        this.disableChallengeResourceVerification = true;
        return this;
    }

    private String getBuildEndpoint(Configuration configuration) {
        if (this.vaultUrl != null) {
            return this.vaultUrl;
        }
        String configEndpoint = configuration.get("AZURE_KEYVAULT_ENDPOINT");
        if (CoreUtils.isNullOrEmpty((CharSequence)configEndpoint)) {
            return null;
        }
        try {
            URL url = new URL(configEndpoint);
            return url.toString();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    static {
        Map properties = CoreUtils.getProperties((String)"azure-key-vault-certificates.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
        DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    }
}

