/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import java.io.IOException;
import java.util.Map;

public final class CertificateBundle
implements JsonSerializable<CertificateBundle> {
    private String id;
    private String kid;
    private String sid;
    private Base64Url x509Thumbprint;
    private CertificatePolicy policy;
    private byte[] cer;
    private String contentType;
    private CertificateAttributes attributes;
    private Map<String, String> tags;
    private Boolean preserveCertOrder;

    private CertificateBundle() {
    }

    public String getId() {
        return this.id;
    }

    public String getKid() {
        return this.kid;
    }

    public String getSid() {
        return this.sid;
    }

    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    public byte[] getCer() {
        return CoreUtils.clone((byte[])this.cer);
    }

    public String getContentType() {
        return this.contentType;
    }

    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", this.cer);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        return jsonWriter.writeEndObject();
    }

    public static CertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateBundle)jsonReader.readObject(reader -> {
            CertificateBundle deserializedCertificateBundle = new CertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateBundle.id = reader.getString();
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedCertificateBundle.kid = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedCertificateBundle.sid = reader.getString();
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    deserializedCertificateBundle.x509Thumbprint = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedCertificateBundle.policy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("cer".equals(fieldName)) {
                    deserializedCertificateBundle.cer = reader.getBinary();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedCertificateBundle.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedCertificateBundle.attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedCertificateBundle.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    deserializedCertificateBundle.preserveCertOrder = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateBundle;
        });
    }
}

