/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class CertificateRestoreParameters
implements JsonSerializable<CertificateRestoreParameters> {
    private final Base64Url certificateBundleBackup;

    public CertificateRestoreParameters(byte[] certificateBundleBackup) {
        this.certificateBundleBackup = certificateBundleBackup == null ? null : Base64Url.encode((byte[])certificateBundleBackup);
    }

    public byte[] getCertificateBundleBackup() {
        if (this.certificateBundleBackup == null) {
            return null;
        }
        return this.certificateBundleBackup.decodedBytes();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.certificateBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    public static CertificateRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateRestoreParameters)jsonReader.readObject(reader -> {
            byte[] certificateBundleBackup = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    Base64Url certificateBundleBackupHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (certificateBundleBackupHolder == null) continue;
                    certificateBundleBackup = certificateBundleBackupHolder.decodedBytes();
                    continue;
                }
                reader.skipChildren();
            }
            return new CertificateRestoreParameters(certificateBundleBackup);
        });
    }
}

