/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

public final class DeletedCertificateItem
implements JsonSerializable<DeletedCertificateItem> {
    private String id;
    private CertificateAttributes attributes;
    private Map<String, String> tags;
    private Base64Url x509Thumbprint;
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;

    private DeletedCertificateItem() {
    }

    public String getId() {
        return this.id;
    }

    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("x5t", Objects.toString(this.x509Thumbprint, null));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedCertificateItem fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedCertificateItem)jsonReader.readObject(reader -> {
            DeletedCertificateItem deserializedDeletedCertificateItem = new DeletedCertificateItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateItem.id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateItem.attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeletedCertificateItem.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    deserializedDeletedCertificateItem.x509Thumbprint = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateItem.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateItem.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedCertificateItem;
        });
    }
}

