/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.IssuerAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerCredentials;
import com.azure.security.keyvault.certificates.implementation.models.OrganizationDetails;
import java.io.IOException;

public final class CertificateIssuerSetParameters
implements JsonSerializable<CertificateIssuerSetParameters> {
    private final String provider;
    private IssuerCredentials credentials;
    private OrganizationDetails organizationDetails;
    private IssuerAttributes attributes;

    public CertificateIssuerSetParameters(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public IssuerCredentials getCredentials() {
        return this.credentials;
    }

    public CertificateIssuerSetParameters setCredentials(IssuerCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public OrganizationDetails getOrganizationDetails() {
        return this.organizationDetails;
    }

    public CertificateIssuerSetParameters setOrganizationDetails(OrganizationDetails organizationDetails) {
        this.organizationDetails = organizationDetails;
        return this;
    }

    public IssuerAttributes getAttributes() {
        return this.attributes;
    }

    public CertificateIssuerSetParameters setAttributes(IssuerAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        jsonWriter.writeJsonField("org_details", (JsonSerializable)this.organizationDetails);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        return jsonWriter.writeEndObject();
    }

    public static CertificateIssuerSetParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateIssuerSetParameters)jsonReader.readObject(reader -> {
            String provider = null;
            IssuerCredentials credentials = null;
            OrganizationDetails organizationDetails = null;
            IssuerAttributes attributes = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provider".equals(fieldName)) {
                    provider = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    credentials = IssuerCredentials.fromJson(reader);
                    continue;
                }
                if ("org_details".equals(fieldName)) {
                    organizationDetails = OrganizationDetails.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    attributes = IssuerAttributes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            CertificateIssuerSetParameters deserializedCertificateIssuerSetParameters = new CertificateIssuerSetParameters(provider);
            deserializedCertificateIssuerSetParameters.credentials = credentials;
            deserializedCertificateIssuerSetParameters.organizationDetails = organizationDetails;
            deserializedCertificateIssuerSetParameters.attributes = attributes;
            return deserializedCertificateIssuerSetParameters;
        });
    }
}

