/*
 * Decompiled with CFR 0.152.
 */
package com.azure.keyvault.jca.org.apache.hc.client5.http.impl.async;

import com.azure.keyvault.jca.org.apache.hc.client5.http.impl.async.LoggingIOSession;
import com.azure.keyvault.jca.org.apache.hc.core5.function.Decorator;
import com.azure.keyvault.jca.org.apache.hc.core5.reactor.IOSession;
import com.azure.keyvault.jca.org.slf4j.Logger;
import com.azure.keyvault.jca.org.slf4j.LoggerFactory;

final class LoggingIOSessionDecorator
implements Decorator<IOSession> {
    public static final LoggingIOSessionDecorator INSTANCE = new LoggingIOSessionDecorator();
    private static final Logger WIRE_LOG = LoggerFactory.getLogger("com.azure.keyvault.jca.org.apache.hc.client5.http.wire");

    private LoggingIOSessionDecorator() {
    }

    @Override
    public IOSession decorate(IOSession ioSession) {
        Logger sessionLog = LoggerFactory.getLogger(ioSession.getClass());
        if (sessionLog.isDebugEnabled() || WIRE_LOG.isDebugEnabled()) {
            return new LoggingIOSession(ioSession, sessionLog, WIRE_LOG);
        }
        return ioSession;
    }
}

