/*
 * Decompiled with CFR 0.152.
 */
package com.azure.keyvault.jca.org.apache.hc.client5.http.impl.classic;

import com.azure.keyvault.jca.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import com.azure.keyvault.jca.org.apache.hc.client5.http.HttpRoute;
import com.azure.keyvault.jca.org.apache.hc.client5.http.UserTokenHandler;
import com.azure.keyvault.jca.org.apache.hc.client5.http.classic.ExecChain;
import com.azure.keyvault.jca.org.apache.hc.client5.http.classic.ExecChainHandler;
import com.azure.keyvault.jca.org.apache.hc.client5.http.classic.ExecRuntime;
import com.azure.keyvault.jca.org.apache.hc.client5.http.impl.ConnectionShutdownException;
import com.azure.keyvault.jca.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.azure.keyvault.jca.org.apache.hc.client5.http.impl.classic.RequestEntityProxy;
import com.azure.keyvault.jca.org.apache.hc.client5.http.impl.classic.ResponseEntityProxy;
import com.azure.keyvault.jca.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import com.azure.keyvault.jca.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.Contract;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.Internal;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.keyvault.jca.org.apache.hc.core5.http.ClassicHttpRequest;
import com.azure.keyvault.jca.org.apache.hc.core5.http.ClassicHttpResponse;
import com.azure.keyvault.jca.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpEntity;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpException;
import com.azure.keyvault.jca.org.apache.hc.core5.http.message.RequestLine;
import com.azure.keyvault.jca.org.apache.hc.core5.io.CloseMode;
import com.azure.keyvault.jca.org.apache.hc.core5.util.Args;
import com.azure.keyvault.jca.org.apache.hc.core5.util.TimeValue;
import com.azure.keyvault.jca.org.slf4j.Logger;
import com.azure.keyvault.jca.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class MainClientExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MainClientExec.class);
    private final HttpClientConnectionManager connectionManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;

    public MainClientExec(HttpClientConnectionManager connectionManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.connectionManager = Args.notNull(connectionManager, "Connection manager");
        this.reuseStrategy = Args.notNull(reuseStrategy, "Connection reuse strategy");
        this.keepAliveStrategy = Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.userTokenHandler = Args.notNull(userTokenHandler, "User token handler");
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        ExecRuntime execRuntime = scope.execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: executing {}", (Object)exchangeId, (Object)new RequestLine(request));
        }
        try {
            RequestEntityProxy.enhance(request);
            ClassicHttpResponse response = execRuntime.execute(exchangeId, request, context);
            Object userToken = context.getUserToken();
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(route, context);
                context.setAttribute("http.user-token", userToken);
            }
            if (this.reuseStrategy.keepAlive(request, response, context)) {
                TimeValue duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                if (LOG.isDebugEnabled()) {
                    String s = duration != null ? "for " + duration : "indefinitely";
                    LOG.debug("{}: connection can be kept alive {}", (Object)exchangeId, (Object)s);
                }
                execRuntime.markConnectionReusable(userToken, duration);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response, null);
            }
            ResponseEntityProxy.enhance(response, execRuntime);
            return new CloseableHttpResponse(response, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (HttpException | IOException | RuntimeException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connectionManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }
}

