/*
 * Decompiled with CFR 0.152.
 */
package com.azure.keyvault.jca.org.apache.hc.client5.http.protocol;

import com.azure.keyvault.jca.org.apache.hc.client5.http.RouteInfo;
import com.azure.keyvault.jca.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.Contract;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.keyvault.jca.org.apache.hc.core5.http.EntityDetails;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpException;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpRequest;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.azure.keyvault.jca.org.apache.hc.core5.http.protocol.HttpContext;
import com.azure.keyvault.jca.org.apache.hc.core5.util.Args;
import com.azure.keyvault.jca.org.slf4j.Logger;
import com.azure.keyvault.jca.org.slf4j.LoggerFactory;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClientConnControl.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            LOG.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "keep-alive");
        }
    }
}

