/*
 * Decompiled with CFR 0.152.
 */
package com.azure.keyvault.jca.org.apache.hc.client5.http.protocol;

import com.azure.keyvault.jca.org.apache.hc.core5.annotation.Contract;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.keyvault.jca.org.apache.hc.core5.http.EntityDetails;
import com.azure.keyvault.jca.org.apache.hc.core5.http.Header;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpException;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpRequest;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.azure.keyvault.jca.org.apache.hc.core5.http.protocol.HttpContext;
import com.azure.keyvault.jca.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.util.Collection;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (this.defaultHeaders != null) {
            for (Header header : this.defaultHeaders) {
                if (request.containsHeader(header.getName())) continue;
                request.addHeader(header);
            }
        }
    }
}

