/*
 * Decompiled with CFR 0.152.
 */
package com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio;

import com.azure.keyvault.jca.org.apache.hc.core5.annotation.Internal;
import com.azure.keyvault.jca.org.apache.hc.core5.http.EndpointDetails;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpException;
import com.azure.keyvault.jca.org.apache.hc.core5.http.ProtocolVersion;
import com.azure.keyvault.jca.org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import com.azure.keyvault.jca.org.apache.hc.core5.http.nio.command.CommandSupport;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio.ClientH2IOEventHandler;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexer;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import com.azure.keyvault.jca.org.apache.hc.core5.io.CloseMode;
import com.azure.keyvault.jca.org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import com.azure.keyvault.jca.org.apache.hc.core5.reactor.IOSession;
import com.azure.keyvault.jca.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.azure.keyvault.jca.org.apache.hc.core5.reactor.ssl.TlsDetails;
import com.azure.keyvault.jca.org.apache.hc.core5.util.Args;
import com.azure.keyvault.jca.org.apache.hc.core5.util.TextUtils;
import com.azure.keyvault.jca.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;

@Internal
public class H2OnlyClientProtocolNegotiator
implements HttpConnectionEventHandler {
    private final ProtocolIOSession ioSession;
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final boolean strictALPNHandshake;
    private final ByteBuffer preface;

    public H2OnlyClientProtocolNegotiator(ProtocolIOSession ioSession, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, boolean strictALPNHandshake) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.strictALPNHandshake = strictALPNHandshake;
        this.preface = ByteBuffer.wrap(ClientHttpProtocolNegotiator.PREFACE);
    }

    @Override
    public void connected(IOSession session) {
        try {
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            if (tlsDetails != null) {
                String applicationProtocol = tlsDetails.getApplicationProtocol();
                if (TextUtils.isEmpty(applicationProtocol)) {
                    if (this.strictALPNHandshake) {
                        throw new HttpException("ALPN: missing application protocol");
                    }
                } else if (!ApplicationProtocol.HTTP_2.id.equals(applicationProtocol)) {
                    throw new HttpException("ALPN: unexpected application protocol '" + applicationProtocol + "'");
                }
            }
            this.writePreface(session);
        }
        catch (Exception ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    private void writePreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            IOSession channel = session;
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            ClientH2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
            ClientH2IOEventHandler newHandler = new ClientH2IOEventHandler(streamMultiplexer);
            newHandler.connected(session);
            this.ioSession.upgrade(newHandler);
        }
    }

    @Override
    public void inputReady(IOSession session, ByteBuffer src) {
        this.outputReady(session);
    }

    @Override
    public void outputReady(IOSession session) {
        try {
            if (this.preface != null) {
                this.writePreface(session);
            } else {
                session.close(CloseMode.GRACEFUL);
            }
        }
        catch (IOException ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    @Override
    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(IOSession session, Exception cause) {
        try {
            CommandSupport.failCommands(session, cause);
        }
        finally {
            session.close(CloseMode.IMMEDIATE);
        }
    }

    @Override
    public void disconnected(IOSession session) {
        CommandSupport.cancelCommands(session);
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

