/*
 * Decompiled with CFR 0.152.
 */
package com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio;

import com.azure.keyvault.jca.org.apache.hc.core5.annotation.Contract;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.Internal;
import com.azure.keyvault.jca.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.keyvault.jca.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import com.azure.keyvault.jca.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.HttpVersionPolicy;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import com.azure.keyvault.jca.org.apache.hc.core5.http2.impl.nio.ServerHttpProtocolNegotiator;
import com.azure.keyvault.jca.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import com.azure.keyvault.jca.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.azure.keyvault.jca.org.apache.hc.core5.util.Args;
import com.azure.keyvault.jca.org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerHttpProtocolNegotiatorFactory
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory http1StreamDuplexerFactory;
    private final ServerH2StreamMultiplexerFactory http2StreamMultiplexerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ServerHttpProtocolNegotiatorFactory(ServerHttp1StreamDuplexerFactory http1StreamDuplexerFactory, ServerH2StreamMultiplexerFactory http2StreamMultiplexerFactory, HttpVersionPolicy versionPolicy, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.http1StreamDuplexerFactory = Args.notNull(http1StreamDuplexerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamMultiplexerFactory = Args.notNull(http2StreamMultiplexerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public ServerHttpProtocolNegotiator createHandler(ProtocolIOSession ioSession, Object attachment) {
        if (this.tlsStrategy != null) {
            this.tlsStrategy.upgrade(ioSession, null, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), attachment != null ? attachment : this.versionPolicy, this.handshakeTimeout);
        }
        return new ServerHttpProtocolNegotiator(ioSession, this.http1StreamDuplexerFactory, this.http2StreamMultiplexerFactory, this.versionPolicy);
    }
}

