/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.KeyVaultKeyManagerFactory;
import com.azure.security.keyvault.jca.KeyVaultKeyStore;
import java.security.AccessController;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;

public class KeyVaultJcaProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    private static final String INFO = "Azure Key Vault JCA Provider";
    private static final String NAME = "AzureKeyVault";
    private static final Double VERSION = 1.0;

    public KeyVaultJcaProvider() {
        super(NAME, VERSION, INFO);
        this.initialize();
    }

    private void initialize() {
        AccessController.doPrivileged(() -> {
            this.putService(new Provider.Service(this, "KeyManagerFactory", "SunX509", KeyVaultKeyManagerFactory.class.getName(), Arrays.asList("SunX509", "IbmX509"), null));
            this.putService(new Provider.Service(this, "KeyStore", "DKS", KeyVaultKeyStore.class.getName(), Collections.singletonList("DKS"), null));
            this.putService(new Provider.Service(this, "KeyStore", NAME, KeyVaultKeyStore.class.getName(), Collections.singletonList(NAME), null));
            return null;
        });
    }
}

