/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.KeyVaultClient;
import com.azure.security.keyvault.jca.KeyVaultLoadStoreParameter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class KeyVaultKeyStore
extends KeyStoreSpi {
    private static final Logger LOGGER = Logger.getLogger(KeyVaultKeyStore.class.getName());
    private List<String> aliases;
    private final HashMap<String, Certificate> certificates = new HashMap();
    private final HashMap<String, Key> certificateKeys = new HashMap();
    private final Date creationDate = new Date();
    private KeyVaultClient keyVaultClient;

    public KeyVaultKeyStore() {
        String keyVaultUri = System.getProperty("azure.keyvault.uri");
        String aadAuthenticationUrl = System.getProperty("azure.keyvault.aad-authentication-url");
        String tenantId = System.getProperty("azure.keyvault.tenant-id");
        String clientId = System.getProperty("azure.keyvault.client-id");
        String clientSecret = System.getProperty("azure.keyvault.client-secret");
        String managedIdentity = System.getProperty("azure.keyvault.managed-identity");
        this.keyVaultClient = clientId != null ? new KeyVaultClient(keyVaultUri, aadAuthenticationUrl, tenantId, clientId, clientSecret) : new KeyVaultClient(keyVaultUri, managedIdentity);
    }

    @Override
    public Enumeration<String> engineAliases() {
        if (this.aliases == null) {
            this.aliases = this.keyVaultClient.getAliases();
        }
        return Collections.enumeration(this.aliases);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.engineIsCertificateEntry(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) {
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        return super.engineEntryInstanceOf(alias, entryClass);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate certificate;
        if (this.certificates.containsKey(alias)) {
            certificate = this.certificates.get(alias);
        } else {
            certificate = this.keyVaultClient.getCertificate(alias);
            if (certificate != null) {
                this.certificates.put(alias, certificate);
                if (!this.aliases.contains(alias)) {
                    this.aliases.add(alias);
                }
            }
        }
        return certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        String alias = null;
        if (cert != null) {
            if (this.aliases == null) {
                this.aliases = this.keyVaultClient.getAliases();
            }
            for (String candidateAlias : this.aliases) {
                Certificate certificate = this.engineGetCertificate(candidateAlias);
                if (!certificate.equals(cert)) continue;
                alias = candidateAlias;
                break;
            }
        }
        return alias;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        Certificate certificate = this.engineGetCertificate(alias);
        if (certificate != null) {
            chain = new Certificate[]{certificate};
        }
        return chain;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return new Date(this.creationDate.getTime());
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        return super.engineGetEntry(alias, protParam);
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        Key key;
        if (this.certificateKeys.containsKey(alias)) {
            key = this.certificateKeys.get(alias);
        } else {
            key = this.keyVaultClient.getKey(alias, password);
            if (key != null) {
                this.certificateKeys.put(alias, key);
                if (this.aliases == null) {
                    this.aliases = this.keyVaultClient.getAliases();
                }
                if (!this.aliases.contains(alias)) {
                    this.aliases.add(alias);
                }
            }
        }
        return key;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        if (this.aliases == null) {
            this.aliases = this.keyVaultClient.getAliases();
        }
        return this.aliases.contains(alias);
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.engineIsCertificateEntry(alias);
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) {
        if (param instanceof KeyVaultLoadStoreParameter) {
            KeyVaultLoadStoreParameter parameter = (KeyVaultLoadStoreParameter)param;
            this.keyVaultClient = parameter.getClientId() != null ? new KeyVaultClient(parameter.getUri(), parameter.getAadAuthenticationUrl(), parameter.getTenantId(), parameter.getClientId(), parameter.getClientSecret()) : (parameter.getManagedIdentity() != null ? new KeyVaultClient(parameter.getUri(), parameter.getManagedIdentity()) : new KeyVaultClient(parameter.getUri()));
        }
        this.sideLoad();
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) {
        this.sideLoad();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate certificate) {
        if (this.aliases == null) {
            this.aliases = this.keyVaultClient.getAliases();
        }
        if (!this.aliases.contains(alias)) {
            this.aliases.add(alias);
            this.certificates.put(alias, certificate);
        }
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        super.engineSetEntry(alias, entry, protParam);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
    }

    @Override
    public int engineSize() {
        return this.aliases != null ? this.aliases.size() : 0;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) {
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) {
    }

    private String[] getFilenames(String path) throws IOException {
        ArrayList<String> filenames;
        block12: {
            filenames = new ArrayList<String>();
            try (InputStream in = this.getClass().getResourceAsStream(path);){
                if (in == null) break block12;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    String resource;
                    while ((resource = br.readLine()) != null) {
                        filenames.add(resource);
                    }
                }
            }
        }
        return filenames.toArray(new String[0]);
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        byte[] bytes;
        try (ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();){
            int r;
            byte[] buffer = new byte[1024];
            while ((r = inputStream.read(buffer)) != -1) {
                byteOutput.write(buffer, 0, r);
            }
            bytes = byteOutput.toByteArray();
        }
        return bytes;
    }

    private void sideLoad() {
        try {
            String[] filenames = this.getFilenames("/keyvault");
            if (filenames.length > 0) {
                for (String filename : filenames) {
                    try (InputStream inputStream = this.getClass().getResourceAsStream("/keyvault/" + filename);){
                        String alias = filename;
                        if (alias == null) continue;
                        if (alias.lastIndexOf(46) != -1) {
                            alias = alias.substring(0, alias.lastIndexOf(46));
                        }
                        byte[] bytes = this.readAllBytes(inputStream);
                        try {
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
                            this.engineSetCertificateEntry(alias, certificate);
                            LOGGER.log(Level.INFO, "Side loaded certificate: {0} from: {1}", new Object[]{alias, filename});
                        }
                        catch (CertificateException e) {
                            LOGGER.log(Level.WARNING, "Unable to side-load certificate from: " + filename, e);
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Unable to determine certificates to side-load", ioe);
        }
    }
}

