/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public class KeyVaultTrustManager
extends X509ExtendedTrustManager {
    private X509TrustManager defaultTrustManager;
    private KeyStore keyStore;

    public KeyVaultTrustManager(KeyStore keyStore) {
        TrustManagerFactory factory;
        this.keyStore = keyStore;
        if (this.keyStore == null) {
            try {
                this.keyStore = KeyStore.getInstance("AzureKeyVault");
                this.keyStore.load(null, null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                ex.printStackTrace();
            }
        }
        try {
            factory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
            factory.init(keyStore);
            this.defaultTrustManager = (X509TrustManager)factory.getTrustManagers()[0];
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            ex.printStackTrace();
        }
        if (this.defaultTrustManager == null) {
            try {
                factory = TrustManagerFactory.getInstance("PKIX", "IbmJSSE");
                factory.init(keyStore);
                this.defaultTrustManager = (X509TrustManager)factory.getTrustManagers()[0];
            }
            catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean pass = true;
        try {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException ce) {
            pass = false;
        }
        if (!pass) {
            String alias = null;
            try {
                alias = this.keyStore.getCertificateAlias(chain[0]);
            }
            catch (KeyStoreException kse) {
                kse.printStackTrace();
            }
            if (alias == null) {
                throw new CertificateException("Unable to verify in keystore");
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean pass = true;
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException ce) {
            pass = false;
        }
        if (!pass) {
            String alias = null;
            try {
                alias = this.keyStore.getCertificateAlias(chain[0]);
            }
            catch (KeyStoreException kse) {
                kse.printStackTrace();
            }
            if (alias == null) {
                throw new CertificateException("Unable to verify in keystore");
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }
}

