/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.keyvault.jca.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.azure.keyvault.jca.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.azure.keyvault.jca.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.azure.keyvault.jca.org.apache.hc.client5.http.impl.classic.HttpClients;
import com.azure.keyvault.jca.org.apache.hc.core5.http.ClassicHttpRequest;
import com.azure.keyvault.jca.org.apache.hc.core5.http.ContentType;
import com.azure.keyvault.jca.org.apache.hc.core5.http.HttpEntity;
import com.azure.keyvault.jca.org.apache.hc.core5.http.io.HttpClientResponseHandler;
import com.azure.keyvault.jca.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.azure.keyvault.jca.org.apache.hc.core5.http.io.entity.HttpEntities;
import com.azure.security.keyvault.jca.RestClient;
import java.io.IOException;
import java.util.Map;

class LegacyRestClient
implements RestClient {
    LegacyRestClient() {
    }

    @Override
    public String get(String url, Map<String, String> headers) {
        String result = null;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                headers.entrySet().forEach(entry -> {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    httpGet.addHeader(key, value);
                });
            }
            HttpClientResponseHandler<String> responseHandler = response -> {
                int status = response.getCode();
                String result1 = null;
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    result1 = entity != null ? EntityUtils.toString(entity) : null;
                }
                return result1;
            };
            result = client.execute((ClassicHttpRequest)httpGet, responseHandler);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    @Override
    public String post(String url, String body, String contentType) {
        String result = null;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(HttpEntities.create(body, ContentType.create(contentType)));
            HttpClientResponseHandler<String> responseHandler = response -> {
                int status = response.getCode();
                String result1 = null;
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    result1 = entity != null ? EntityUtils.toString(entity) : null;
                }
                return result1;
            };
            result = client.execute((ClassicHttpRequest)httpPost, responseHandler);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }
}

