/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.keyvault.jca.com.fasterxml.jackson.core.JsonProcessingException;
import com.azure.keyvault.jca.com.fasterxml.jackson.databind.DeserializationFeature;
import com.azure.keyvault.jca.com.fasterxml.jackson.databind.ObjectMapper;
import com.azure.security.keyvault.jca.JsonConverter;
import java.util.logging.Level;
import java.util.logging.Logger;

class JacksonJsonConverter
implements JsonConverter {
    private static final Logger LOGGER = Logger.getLogger(JacksonJsonConverter.class.getName());

    JacksonJsonConverter() {
    }

    @Override
    public Object fromJson(String string, Class<?> resultClass) {
        LOGGER.entering("JacksonJsonConverter", "fromJson", new Object[]{string, resultClass});
        Object result = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            result = objectMapper.readValue(string, resultClass);
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.WARNING, "Unable to convert from JSON", e);
        }
        LOGGER.exiting("JacksonJsonConverter", "fromJson", result);
        return result;
    }

    @Override
    public String toJson(Object object) {
        LOGGER.entering("JacksonJsonConverter", "toJson", object);
        String result = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            result = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.WARNING, "Unable to convert to JSON", e);
        }
        LOGGER.exiting("JacksonJsonConverter", "toJson", result);
        return result;
    }
}

