/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.AuthClient;
import com.azure.security.keyvault.jca.DelegateRestClient;
import com.azure.security.keyvault.jca.JsonConverter;
import com.azure.security.keyvault.jca.JsonConverterFactory;
import com.azure.security.keyvault.jca.RestClientFactory;
import com.azure.security.keyvault.jca.UriUtil;
import com.azure.security.keyvault.jca.model.CertificateBundle;
import com.azure.security.keyvault.jca.model.CertificateItem;
import com.azure.security.keyvault.jca.model.CertificateListResult;
import com.azure.security.keyvault.jca.model.CertificatePolicy;
import com.azure.security.keyvault.jca.model.KeyProperties;
import com.azure.security.keyvault.jca.model.SecretBundle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class KeyVaultClient
extends DelegateRestClient {
    private static final Logger LOGGER = Logger.getLogger(KeyVaultClient.class.getName());
    private static final String HTTPS_PREFIX = "https://";
    private static final String API_VERSION_POSTFIX = "?api-version=7.1";
    private String keyVaultBaseUri;
    private final String keyVaultUrl;
    private String aadAuthenticationUrl;
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String managedIdentity;

    KeyVaultClient(String keyVaultUri) {
        this(keyVaultUri, null, null, null, null);
    }

    KeyVaultClient(String keyVaultUri, String managedIdentity) {
        this(keyVaultUri, null, null, null, managedIdentity);
    }

    KeyVaultClient(String keyVaultUri, String tenantId, String clientId, String clientSecret) {
        this(keyVaultUri, tenantId, clientId, clientSecret, null);
    }

    KeyVaultClient(String keyVaultUri, String tenantId, String clientId, String clientSecret, String managedIdentity) {
        super(RestClientFactory.createClient());
        LOGGER.log(Level.INFO, "Using Azure Key Vault: {0}", keyVaultUri);
        if (!keyVaultUri.endsWith("/")) {
            keyVaultUri = keyVaultUri + "/";
        }
        this.keyVaultUrl = keyVaultUri;
        String domainNameSuffix = Optional.of(keyVaultUri).map(uri -> uri.split("\\.", 2)[1]).map(suffix -> suffix.substring(0, suffix.length() - 1)).get();
        this.keyVaultBaseUri = HTTPS_PREFIX + domainNameSuffix;
        this.aadAuthenticationUrl = UriUtil.getAADLoginURIByKeyVaultBaseUri(this.keyVaultBaseUri);
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.managedIdentity = managedIdentity;
    }

    private String getAccessToken() {
        LOGGER.entering("KeyVaultClient", "getAccessToken");
        String accessToken = null;
        try {
            AuthClient authClient = new AuthClient();
            String resource = URLEncoder.encode(this.keyVaultBaseUri, "UTF-8");
            if (this.managedIdentity != null) {
                this.managedIdentity = URLEncoder.encode(this.managedIdentity, "UTF-8");
            }
            accessToken = this.tenantId != null && this.clientId != null && this.clientSecret != null ? authClient.getAccessToken(resource, this.aadAuthenticationUrl, this.tenantId, this.clientId, this.clientSecret) : authClient.getAccessToken(resource, this.managedIdentity);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Unsupported encoding or missing Httpclient", throwable);
        }
        LOGGER.exiting("KeyVaultClient", "getAccessToken", accessToken);
        return accessToken;
    }

    List<String> getAliases() {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.getAccessToken());
        String url = String.format("%scertificates%s", this.keyVaultUrl, API_VERSION_POSTFIX);
        String response = this.get(url, headers);
        CertificateListResult certificateListResult = null;
        if (response != null) {
            JsonConverter converter = JsonConverterFactory.createJsonConverter();
            certificateListResult = (CertificateListResult)converter.fromJson(response, CertificateListResult.class);
        }
        if (certificateListResult != null && certificateListResult.getValue().size() > 0) {
            for (CertificateItem certificateItem : certificateListResult.getValue()) {
                String id = certificateItem.getId();
                String alias = id.substring(id.indexOf("certificates") + "certificates".length() + 1);
                result.add(alias);
            }
        }
        return result;
    }

    private CertificateBundle getCertificateBundle(String alias) {
        CertificateBundle result = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.getAccessToken());
        String url = String.format("%scertificates/%s%s", this.keyVaultUrl, alias, API_VERSION_POSTFIX);
        String response = this.get(url, headers);
        if (response != null) {
            JsonConverter converter = JsonConverterFactory.createJsonConverter();
            result = (CertificateBundle)converter.fromJson(response, CertificateBundle.class);
        }
        return result;
    }

    Certificate getCertificate(String alias) {
        String certificateString;
        LOGGER.entering("KeyVaultClient", "getCertificate", alias);
        LOGGER.log(Level.INFO, "Getting certificate for alias: {0}", alias);
        X509Certificate certificate = null;
        CertificateBundle certificateBundle = this.getCertificateBundle(alias);
        if (certificateBundle != null && (certificateString = certificateBundle.getCer()) != null) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(certificateString)));
            }
            catch (CertificateException ce) {
                LOGGER.log(Level.WARNING, "Certificate error", ce);
            }
        }
        LOGGER.exiting("KeyVaultClient", "getCertificate", certificate);
        return certificate;
    }

    Key getKey(String alias, char[] password) {
        LOGGER.entering("KeyVaultClient", "getKey", new Object[]{alias, password});
        LOGGER.log(Level.INFO, "Getting key for alias: {0}", alias);
        Key key = null;
        CertificateBundle certificateBundle = this.getCertificateBundle(alias);
        boolean isExportable = Optional.ofNullable(certificateBundle).map(CertificateBundle::getPolicy).map(CertificatePolicy::getKeyProperties).map(KeyProperties::isExportable).orElse(false);
        if (isExportable) {
            String certificateSecretUri = certificateBundle.getSid();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + this.getAccessToken());
            String body = this.get(certificateSecretUri + API_VERSION_POSTFIX, headers);
            if (body != null) {
                JsonConverter converter = JsonConverterFactory.createJsonConverter();
                SecretBundle secretBundle = (SecretBundle)converter.fromJson(body, SecretBundle.class);
                if (secretBundle.getContentType().equals("application/x-pkcs12")) {
                    try {
                        KeyStore keyStore = KeyStore.getInstance("PKCS12");
                        keyStore.load(new ByteArrayInputStream(Base64.getDecoder().decode(secretBundle.getValue())), "".toCharArray());
                        alias = keyStore.aliases().nextElement();
                        key = keyStore.getKey(alias, "".toCharArray());
                    }
                    catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                        LOGGER.log(Level.WARNING, "Unable to decode key", ex);
                    }
                }
                if (secretBundle.getContentType().equals("application/x-pem-file")) {
                    try {
                        key = this.createPrivateKeyFromPem(secretBundle.getValue());
                    }
                    catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
                        LOGGER.log(Level.WARNING, "Unable to decode key", ex);
                    }
                }
            }
        }
        LOGGER.exiting("KeyVaultClient", "getKey", key);
        return key;
    }

    private PrivateKey createPrivateKeyFromPem(String pemString) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new StringReader(pemString));){
            String line = reader.readLine();
            if (line == null || !line.contains("BEGIN PRIVATE KEY")) {
                throw new IllegalArgumentException("No PRIVATE KEY found");
            }
            line = "";
            while (line != null) {
                if (line.contains("END PRIVATE KEY")) {
                    break;
                }
                builder.append(line);
                line = reader.readLine();
            }
        }
        byte[] bytes = Base64.getDecoder().decode(builder.toString());
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(spec);
    }

    String getKeyVaultBaseUri() {
        return this.keyVaultBaseUri;
    }

    String getAadAuthenticationUrl() {
        return this.aadAuthenticationUrl;
    }
}

