/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.KeyVaultKeyManager;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;

public class KeyVaultKeyManagerFactory
extends KeyManagerFactorySpi {
    private static final Logger LOGGER = Logger.getLogger(KeyVaultKeyManagerFactory.class.getName());
    private final List<KeyManager> keyManagers = new ArrayList<KeyManager>();

    @Override
    protected void engineInit(KeyStore keystore, char[] password) {
        LOGGER.entering("KeyVaultKeyManagerFactory", "engineInit", new Object[]{keystore, password});
        KeyVaultKeyManager manager = new KeyVaultKeyManager(keystore, password);
        this.keyManagers.add(manager);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) {
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        LOGGER.exiting("KeyVaultKeyManagerFactory", "engineGetKeyManagers", this.keyManagers);
        return this.keyManagers.toArray(new KeyManager[0]);
    }
}

