/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.RestClient;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

class LegacyRestClient
implements RestClient {
    LegacyRestClient() {
    }

    @Override
    public String get(String url, Map<String, String> headers) {
        String result = null;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                headers.entrySet().forEach(entry -> {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    httpGet.addHeader(key, value);
                });
            }
            result = client.execute((HttpUriRequest)httpGet, this.createResponseHandler());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    @Override
    public String post(String url, String body, String contentType) {
        String result = null;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(new StringEntity(body, ContentType.create(contentType)));
            result = client.execute((HttpUriRequest)httpPost, this.createResponseHandler());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    private ResponseHandler<String> createResponseHandler() {
        return response -> {
            int status = response.getStatusLine().getStatusCode();
            String result = null;
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                result = entity != null ? EntityUtils.toString(entity) : null;
            }
            return result;
        };
    }
}

