/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

public class UriUtil {
    public static final String KEY_VAULT_BASE_URI_GLOBAL = "https://vault.azure.net";
    public static final String KEY_VAULT_BASE_URI_CN = "https://vault.azure.cn";
    public static final String KEY_VAULT_BASE_URI_US = "https://vault.usgovcloudapi.net";
    public static final String KEY_VAULT_BASE_URI_DE = "https://vault.microsoftazure.de";
    public static final String AAD_LOGIN_URI_GLOBAL = "https://login.microsoftonline.com/";
    public static final String AAD_LOGIN_URI_CN = "https://login.partner.microsoftonline.cn/";
    public static final String AAD_LOGIN_URI_US = "https://login.microsoftonline.us/";
    public static final String AAD_LOGIN_URI_DE = "https://login.microsoftonline.de/";

    static String getAADLoginURIByKeyVaultBaseUri(String keyVaultBaseUri) {
        String aadAuthenticationUrl;
        switch (keyVaultBaseUri) {
            case "https://vault.azure.net": {
                aadAuthenticationUrl = AAD_LOGIN_URI_GLOBAL;
                break;
            }
            case "https://vault.azure.cn": {
                aadAuthenticationUrl = AAD_LOGIN_URI_CN;
                break;
            }
            case "https://vault.usgovcloudapi.net": {
                aadAuthenticationUrl = AAD_LOGIN_URI_US;
                break;
            }
            case "https://vault.microsoftazure.de": {
                aadAuthenticationUrl = AAD_LOGIN_URI_DE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Property of azure.keyvault.uri is illegal.");
            }
        }
        return aadAuthenticationUrl;
    }
}

