/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca;

import com.azure.security.keyvault.jca.KeyVaultLoadStoreParameter;
import com.azure.security.keyvault.jca.implementation.certificates.AzureCertificates;
import com.azure.security.keyvault.jca.implementation.certificates.ClasspathCertificates;
import com.azure.security.keyvault.jca.implementation.certificates.JreCertificates;
import com.azure.security.keyvault.jca.implementation.certificates.KeyVaultCertificates;
import com.azure.security.keyvault.jca.implementation.certificates.SpecificPathCertificates;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class KeyVaultKeyStore
extends KeyStoreSpi {
    public static final String KEY_STORE_TYPE = "AzureKeyVault";
    public static final String ALGORITHM_NAME = "AzureKeyVault";
    private static final Logger LOGGER = Logger.getLogger(KeyVaultKeyStore.class.getName());
    private final JreCertificates jreCertificates;
    private final SpecificPathCertificates wellKnowCertificates;
    private final SpecificPathCertificates customCertificates;
    private final KeyVaultCertificates keyVaultCertificates;
    private final ClasspathCertificates classpathCertificates;
    private final List<AzureCertificates> allCertificates;
    private final Date creationDate;
    private final boolean refreshCertificatesWhenHaveUnTrustCertificate;
    final String wellKnowPath = Optional.ofNullable(System.getProperty("azure.cert-path.well-known")).orElse("/etc/certs/well-known/");
    final String customPath = Optional.ofNullable(System.getProperty("azure.cert-path.custom")).orElse("/etc/certs/custom/");

    public KeyVaultKeyStore() {
        this.creationDate = new Date();
        String keyVaultUri = System.getProperty("azure.keyvault.uri");
        String tenantId = System.getProperty("azure.keyvault.tenant-id");
        String clientId = System.getProperty("azure.keyvault.client-id");
        String clientSecret = System.getProperty("azure.keyvault.client-secret");
        String managedIdentity = System.getProperty("azure.keyvault.managed-identity");
        long refreshInterval = Optional.of("azure.keyvault.jca.certificates-refresh-interval").map(System::getProperty).map(Long::valueOf).orElse(0L);
        this.refreshCertificatesWhenHaveUnTrustCertificate = Optional.of("azure.keyvault.jca.refresh-certificates-when-have-un-trust-certificate").map(System::getProperty).map(Boolean::parseBoolean).orElse(false);
        this.jreCertificates = JreCertificates.getInstance();
        this.wellKnowCertificates = SpecificPathCertificates.getSpecificPathCertificates(this.wellKnowPath);
        this.customCertificates = SpecificPathCertificates.getSpecificPathCertificates(this.customPath);
        this.keyVaultCertificates = new KeyVaultCertificates(refreshInterval, keyVaultUri, tenantId, clientId, clientSecret, managedIdentity);
        this.classpathCertificates = new ClasspathCertificates();
        this.allCertificates = Arrays.asList(this.jreCertificates, this.wellKnowCertificates, this.customCertificates, this.keyVaultCertificates, this.classpathCertificates);
    }

    public static KeyStore getKeyVaultKeyStoreBySystemProperty() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore keyStore = KeyStore.getInstance("AzureKeyVault");
        KeyVaultLoadStoreParameter parameter = new KeyVaultLoadStoreParameter(System.getProperty("azure.keyvault.uri"), System.getProperty("azure.keyvault.tenant-id"), System.getProperty("azure.keyvault.client-id"), System.getProperty("azure.keyvault.client-secret"), System.getProperty("azure.keyvault.managed-identity"));
        keyStore.load(parameter);
        return keyStore;
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.getAllAliases());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.engineIsCertificateEntry(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) {
        this.allCertificates.forEach(a -> a.deleteEntry(alias));
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        return super.engineEntryInstanceOf(alias, entryClass);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate certificate = this.allCertificates.stream().map(AzureCertificates::getCertificates).filter(a -> a.containsKey(alias)).findFirst().map(certificates -> (Certificate)certificates.get(alias)).orElse(null);
        if (this.refreshCertificatesWhenHaveUnTrustCertificate && certificate == null) {
            this.keyVaultCertificates.refreshCertificates();
            certificate = this.keyVaultCertificates.getCertificates().get(alias);
        }
        return certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        String alias = null;
        if (cert != null) {
            List<String> aliasList = this.getAllAliases();
            for (String candidateAlias : aliasList) {
                Certificate certificate = this.engineGetCertificate(candidateAlias);
                if (!certificate.equals(cert)) continue;
                alias = candidateAlias;
                break;
            }
        }
        if (this.refreshCertificatesWhenHaveUnTrustCertificate && alias == null) {
            alias = this.keyVaultCertificates.refreshAndGetAliasByCertificate(cert);
        }
        return alias;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        Certificate certificate = this.engineGetCertificate(alias);
        if (certificate != null) {
            chain = new Certificate[]{certificate};
        }
        return chain;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return new Date(this.creationDate.getTime());
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        return super.engineGetEntry(alias, protParam);
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        return this.allCertificates.stream().map(AzureCertificates::getCertificateKeys).filter(a -> a.containsKey(alias)).findFirst().map(certificateKeys -> (Key)certificateKeys.get(alias)).orElse(null);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.getAllAliases().contains(alias);
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.engineIsCertificateEntry(alias);
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) {
        if (param instanceof KeyVaultLoadStoreParameter) {
            KeyVaultLoadStoreParameter parameter = (KeyVaultLoadStoreParameter)param;
            this.keyVaultCertificates.updateKeyVaultClient(parameter.getUri(), parameter.getTenantId(), parameter.getClientId(), parameter.getClientSecret(), parameter.getManagedIdentity());
        }
        this.classpathCertificates.loadCertificatesFromClasspath();
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) {
        this.classpathCertificates.loadCertificatesFromClasspath();
    }

    private List<String> getAllAliases() {
        ArrayList<String> allAliases = new ArrayList<String>(this.jreCertificates.getAliases());
        HashMap<String, List> aliasLists = new HashMap<String, List>();
        aliasLists.put("well known certificates", this.wellKnowCertificates.getAliases());
        aliasLists.put("custom certificates", this.customCertificates.getAliases());
        aliasLists.put("key vault certificates", this.keyVaultCertificates.getAliases());
        aliasLists.put("class path certificates", this.classpathCertificates.getAliases());
        aliasLists.forEach((certificatesType, certificates) -> certificates.forEach(alias -> {
            if (allAliases.contains(alias)) {
                LOGGER.log(Level.FINE, String.format("The certificate %s under %s already exists", alias, certificatesType));
            } else {
                allAliases.add((String)alias);
            }
        }));
        return allAliases;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate certificate) {
        if (this.getAllAliases().contains(alias)) {
            LOGGER.log(Level.WARNING, "Cannot overwrite own certificate");
            return;
        }
        this.classpathCertificates.setCertificateEntry(alias, certificate);
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        super.engineSetEntry(alias, entry, protParam);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
    }

    @Override
    public int engineSize() {
        return this.getAllAliases().size();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) {
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) {
    }
}

