/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.certificates;

import com.azure.security.keyvault.jca.implementation.certificates.AzureCertificates;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class JreCertificates
implements AzureCertificates {
    private static final Logger LOGGER = Logger.getLogger(JreCertificates.class.getName());
    private final List<String> aliases;
    private final Map<String, Certificate> certs;
    private final Map<String, Key> keys;
    private static final JreCertificates INSTANCE = new JreCertificates();

    private JreCertificates() {
        KeyStore jreKeyStore = JREKeyStore.getDefault();
        this.aliases = Optional.ofNullable(jreKeyStore).map(a -> {
            try {
                return Collections.unmodifiableList(Collections.list(a.aliases()));
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.WARNING, "Unable to load the jre key store aliases.", e);
                return null;
            }
        }).orElseGet(Collections::emptyList);
        this.certs = this.aliases.stream().collect(HashMap::new, (m, v) -> {
            try {
                m.put(v, jreKeyStore.getCertificate((String)v));
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.WARNING, "Unable to get the jre key store certificate.", e);
            }
        }, HashMap::putAll);
        this.keys = Collections.emptyMap();
    }

    public static JreCertificates getInstance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Map<String, Certificate> getCertificates() {
        return this.certs;
    }

    @Override
    public Map<String, Key> getCertificateKeys() {
        return this.keys;
    }

    @Override
    public void deleteEntry(String alias) {
    }

    private static class JREKeyStore {
        private static final String JAVA_HOME = JREKeyStore.privilegedGetProperty("java.home", "");
        private static final Path STORE_PATH = Paths.get(JAVA_HOME, new String[0]).resolve("lib").resolve("security");
        private static final Path DEFAULT_STORE = STORE_PATH.resolve("cacerts");
        private static final Path JSSE_DEFAULT_STORE = STORE_PATH.resolve("jssecacerts");
        private static final String KEY_STORE_PASSWORD = JREKeyStore.privilegedGetProperty("javax.net.ssl.keyStorePassword", "changeit");

        private JREKeyStore() {
        }

        private static KeyStore getDefault() {
            KeyStore defaultKeyStore = null;
            try {
                defaultKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                JREKeyStore.loadKeyStore(defaultKeyStore);
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.WARNING, "Unable to get the jre key store.", e);
            }
            return defaultKeyStore;
        }

        private static void loadKeyStore(KeyStore ks) {
            try (InputStream inputStream = Files.newInputStream(JREKeyStore.getKeyStoreFile(), new OpenOption[0]);){
                ks.load(inputStream, KEY_STORE_PASSWORD.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                LOGGER.log(Level.WARNING, "unable to load the jre key store", e);
            }
        }

        private static Path getKeyStoreFile() {
            return Stream.of(JREKeyStore.getConfiguredKeyStorePath(), JSSE_DEFAULT_STORE, DEFAULT_STORE).filter(Objects::nonNull).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(Files::isReadable).findFirst().orElse(null);
        }

        private static Path getConfiguredKeyStorePath() {
            String configuredKeyStorePath = JREKeyStore.privilegedGetProperty("javax.net.ssl.keyStore", "");
            return Optional.of(configuredKeyStorePath).filter(path -> !path.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        }

        private static String privilegedGetProperty(String theProp, String defaultVal) {
            return AccessController.doPrivileged(() -> {
                String value = System.getProperty(theProp, "");
                return value.isEmpty() ? defaultVal : value;
            });
        }
    }
}

